//////////////////////////////////////////////////////////////////////////
//                               house.c                                //
// Purpose                                                              //
// =======                                                              //
// To produce a simple drawing of a house.                              //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// C. Phillips       12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input is required.                                                //
// A simple house is drawn in a Canvas window.                          //
//////////////////////////////////////////////////////////////////////////


#include "Canvas.h"

int main()
{
  const int XMAX             = 200;
  const int YMAX             = XMAX;
  const int HOUSE_WIDTH      = 70;
  const int HOUSE_HEIGHT     = 50;
  const int ROOF_HEIGHT      = 15;
  const int START_X_POSITION = 10;
  const int START_Y_POSITION = START_X_POSITION;

  Canvas picture;

  // Get ready for drawing
  picture.setSize(XMAX, YMAX);
  picture.penUp();
  picture.moveTo(START_X_POSITION, START_Y_POSITION);

  // Draw the body of the picture
  picture.penDown();
  picture.moveRelative(HOUSE_WIDTH, 0);
  picture.moveRelative(0, HOUSE_HEIGHT);
  picture.moveRelative(-HOUSE_WIDTH, 0);
  picture.moveRelative(0, -HOUSE_HEIGHT);
  picture.penUp();

  // Now draw the roof
  picture.moveRelative(0, HOUSE_HEIGHT);
  picture.penDown();
  picture.moveRelative(HOUSE_WIDTH / 2, ROOF_HEIGHT);
  picture.moveRelative(HOUSE_WIDTH / 2, -ROOF_HEIGHT);
  picture.penUp();

  return 0;
} // end main()
