//////////////////////////////////////////////////////////////////////////
//                              uptolow.c                               //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// To convert uppercase letters to lowercase.                           //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// C. Phillips       12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// Input is a set of letters, terminated by a punctuation mark. If a    //
//   non-letter or non-punctuation mark is read then an error is        //
//   reported and the program terminated.                               //
// Output is the input sequence of letters with all uppercase letters   // 
//   replaced by their lowercase equivalents.                           //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <cctype>
using namespace std;

#include "Text.h"
#include "error.h"

int main()
{
  char ch;
  Text message = "";
  
  cout << "Type a sequence of letters, terminated by a punctuation mark"
       << endl << "All spaces will be ignored" << endl << endl;
  cin  >> ch;
  while (!ispunct(ch))
  {
    if (!isalpha(ch))
    {
      Text errorMessage = "Got: " + message + 
                          " then invalid character read: " + Text(ch);
      error(errorMessage);
      return -1;                       // Terminate the program
    }
    message += Text(tolower(ch));
    cin >> ch;
  }
  cout << endl << endl
       << "The result of conversion is" << endl << endl
       << message << endl;
  return 0;
} // end main()

