//////////////////////////////////////////////////////////////////////////
//                              counttracks.c                           //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// This program counts the number of tracks on a disc.                  //
// It demonstrates the use of a while statement.                        //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input required. CDPlayer graphics displayed on the screen.        //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "CDisc.h"
#include "CSDiscSet.h"
#include "CDPlayer.h"

int main()
{
  CDPlayer  myPlayer;
  CSDiscSet someDiscs;
  CDisc     aDisc;

  // The following member function call can be uncommented in order to
  // turn the graphics display off. This may have the effect of speeding
  // up the execution of your program. However, you'll need the graphics
  // on if you want to check the printed output of the program against
  // the track total displayed in the CD player window.
  
  // myPlayer.graphicsOff();              // Turn graphics off
  
  aDisc = someDiscs.selectDisc("We Can't Dance");

  // Load disc into CD Player
  myPlayer.on();                          // Power On
  myPlayer.open();                        // Put disc into player
  myPlayer.load(aDisc);
  myPlayer.close();
  
  // Count number of tracks on this disc
  int trackCount = 0;
  
  while (myPlayer.status() != PLAYER_ERROR)
  {
    trackCount = trackCount + 1;              // Add 1 to trackCount
    myPlayer.nextTrack();                     // Try to move to next track.
  }                                           //   Changes status
  
  // Print out track total
  cout << "Disk contains " << trackCount
       << " tracks" << endl;
  
                                          // Remove disc from player     
  myPlayer.open();
  aDisc = myPlayer.unload();                  // Remove disc
  myPlayer.close();
  myPlayer.off();                             // Power off

  return 0;
} // end main()
