//////////////////////////////////////////////////////////////////////////
//                               ifplaycd.c                             //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// This program checks the status of a disc before playing that disc.   //
// This is to illustrate the use of an if-else statement in C++.        //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input required.                                                   //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "CDisc.h"
#include "CSDiscSet.h"
#include "CDPlayer.h"

int main()
{
  CDPlayer    myPlayer;
  CSDiscSet   someDiscs;
  CDisc       aDisc;

  //aDisc = someDiscs.selectDisc("The 1812 Overture"); // A Good disc
  aDisc = someDiscs.selectDisc("Bootlegged 1812");  // A Bad disc

  myPlayer.on();                // Power on player
                                // Play the disc
                                     // Put disc into player
  myPlayer.open();                         // Open drawer
  myPlayer.load(aDisc);                    // Load disc
  myPlayer.close();                        // Close drawer
  if (myPlayer.status() == DISC_OK)  // Is disc OK?
  {                                        // Instruct player to play
    myPlayer.play();                            // Press "Play" button
  }
  else
  {
    cout << "This disc cannot be played" << endl;
  }
                                     // Remove disc from player
  myPlayer.open();                         // Open drawer
  aDisc = myPlayer.unload();               // Unload disc
  myPlayer.close();                        // Close drawer

  myPlayer.off();               // Power off player
  
  return 0;  
} // end main()
