//////////////////////////////////////////////////////////////////////////
//                             movetotrack.c                            //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// This program moves to a requested track before playing a CD.         //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// The user types in the required track number.                         //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "CDisc.h"
#include "CSDiscSet.h"
#include "CDPlayer.h"

int main()
{
  CDPlayer   myPlayer;
  CSDiscSet  someDiscs;
  CDisc      aDisc;
  int        requiredTrack;
  
  aDisc = someDiscs.selectDisc("The 1812 Overture");

  myPlayer.on();                              // Power On
  myPlayer.open();                            // Put disc into player
  myPlayer.load(aDisc);
  myPlayer.close();
  
  // Determine which track user wishes to commence playing from 

  cout << "Type in required track number: ";
  cin  >> requiredTrack;
                                              // Skip requiredTrack tracks 
  for (int onTrack = 0;  onTrack < requiredTrack; onTrack += 1)
  {
    myPlayer.nextTrack();
  }

  myPlayer.play();                            // Instruct player to play
  myPlayer.open();                            // Remove disc from player
  aDisc = myPlayer.unload(); 
  myPlayer.close();
  myPlayer.off();                             // Power off
  
  return 0;
} // end main()
