//////////////////////////////////////////////////////////////////////////
//                               MultipleIfplaycd.c                     //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// This program checks the status of a disc before playing that disc.   //
// This is to illustrate the use of a multiple if statements in C++.    //
// In turn this illustrates the difference between a multiway if and    //
// multiple if statements. (The multiple if statements (here) is the    //
// wrong one.                                                           //
//                                                                      //
// Try editing the code below to force different errors and see how the //
// program behaves, trying to identify where it goes wrong (and why).   //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           27 October 1999                                    //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input required.                                                   //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "CDisc.h"
#include "CSDiscSet.h"
#include "CDPlayer.h"

int main()
{
  CDPlayer     myPlayer;
  CSDiscSet    someDiscs;
  CDisc        aDisc;
  PlayerStatus currentStatus;

  aDisc = someDiscs.selectDisc("The 1812 Overture"); // A Good disc
  //aDisc = someDiscs.selectDisc("Bootlegged 1812");  // A Bad disc

  myPlayer.on();                // Power on player
                                // Play the disc
                                     // Put disc into player
  myPlayer.open();                         // Open drawer
  myPlayer.load(aDisc);                    // Load disc
  myPlayer.close();                        // Close drawer
  currentStatus = myPlayer.status(); // Check the status of the CD
  if (currentStatus == DISC_OK)  // Is disc OK?
  {                                        // Instruct player to play
    myPlayer.play();                            // Press "Play" button
  }
  if (currentStatus == DISC_BAD)
  {
    cout << "This disc cannot be played" << endl;
  }
  if (currentStatus == PLAYER_EMPTY)
  {
    cout << "No disc has been loaded" << endl;
  }
  if (currentStatus == PLAYER_ERROR)
  {
    cout << "Player's status is ERROR" << endl;
  }
  else
  {
    cout << "Error: unknown status value" << endl; // Defensive programming
  }
                                     // Remove disc from player
  myPlayer.open();                         // Open drawer
  aDisc = myPlayer.unload();               // Unload disc
  myPlayer.close();                        // Close drawer

  myPlayer.off();               // Power off player
  
  return 0;  
} // end main()
