//////////////////////////////////////////////////////////////////////////
//                          DrawShapes.h                                //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// Header file containing the interfaces of the shape-drawing functions.//
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// C. Phillips       12 December 1995                                   //
//////////////////////////////////////////////////////////////////////////

#include "Canvas.h"
                          //////////////////////////////
                          // Square Drawing Functions //
                          //////////////////////////////
bool   drawSquare(Canvas& picture);
bool   drawSquare(Canvas& picture, int sideLength);
bool   drawSquare(Canvas& picture, int sideLength, int xPos, int yPos);
bool   drawSquare(Canvas& picture, int sideLength, int xPos, int yPos,
                  int rotationAngle);
bool   drawSquare(Canvas& picture, int sideLength, int xPos, int yPos,
                  double rotationAngle);
                
                         ////////////////////////////////
                         // Triangle Drawing Functions //
                         ////////////////////////////////
bool   drawTriangle(Canvas& picture);
bool   drawTriangle(Canvas& picture, int side1, int side2, int side3);
bool   drawTriangle(Canvas& picture, int side1, int side2, int side3,
                    int xPos, int yPos);
bool   drawTriangle(Canvas& picture, int side1, int side2, int side3,
                    int xPos, int yPos,
                    int rotationAngle);
bool   drawTriangle(Canvas& picture, int side1, int side2, int side3,
                    int xPos, int yPos, double rotationAngle);
                  
                          ///////////////////////////////
                          // Polygon Drawing Functions //
                          ///////////////////////////////
bool   drawRegularPolygon(Canvas& picture);
bool   drawRegularPolygon(Canvas& picture, int numberOfSides);
bool   drawRegularPolygon(Canvas& picture, int numberOfSides, int sideLength);
bool   drawRegularPolygon(Canvas& picture, int numberOfSides, int sideLength, 
                          int xPos, int yPos);
bool   drawRegularPolygon(Canvas& picture, int numberOfSides, int sideLength, 
                          int xPos, int yPos, int rotationAngle);
bool   drawRegularPolygon(Canvas& picture, int numberOfSides, int sideLength, 
                          int xPos, int yPos, double rotationAngle);

