//////////////////////////////////////////////////////////////////////////
//                             Main.c                                   //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// Test program for the shape-drawing functions.                        //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// C. Phillips       12 December 1995                                   //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <cmath>
using namespace std;

#include "error.h"
#include "Canvas.h"
#include "DrawShapes.h"

const double DEGREES_TO_RADIANS = atan(1.0) / 45.0;

void testSquares1();
void testSquares2();
void testTriangles1();
void testTriangles2();
void testPolygons1();
void testPolygons2();
void test(Text message, bool flag);
bool getYesOrNo(Text message); 

int main()
{
  cout << "Testing of the shape-drawing functions" << endl;
  
  if (getYesOrNo("Concentric square test"))
  {
    testSquares1();
  }
  if (getYesOrNo("Rotated square test"))
  {
    testSquares2();
  }
  if (getYesOrNo("Triangle test"))
  {
    testTriangles1();
  }
  if (getYesOrNo("Rotated right-angle triangle test"))
  {
    testTriangles2();
  }
  if (getYesOrNo("Polygon test"))
  {
    testPolygons1();
  }
  if (getYesOrNo("Rotated polygon test"))
  {
    testPolygons2();
  }
  
  cout << "Tests complete" << endl;
  return 0;
} // end main()

void testSquares1()
{
  const int XYMAX      = 200;
  Canvas    picture;
  int       bottomLeft;
  int       sideLength;
  
  cout << "Drawing concentric squares" << endl;

  picture.setSize(XYMAX, XYMAX);
  
  // Draw three enclosing squares of increasing size

  // Default side length
  bottomLeft = 60;
  picture.moveTo(bottomLeft, bottomLeft);
  test("Default side length version of drawSquare",
       drawSquare(picture)); 
                                         
  // Specified side length
  bottomLeft -= 10;
  sideLength = 70;
  picture.moveTo(bottomLeft, bottomLeft);
  test("Default position version of drawSquare",
       drawSquare(picture, sideLength));                          

  // Specified position
  bottomLeft -= 10;
  sideLength += 20;
  test("Specified position version of drawSquare",
       drawSquare(picture, sideLength, bottomLeft, bottomLeft));
        
  return;
} // end testSquares1()

void testSquares2()
{
  const int XMAX   = 200;
  const int YMAX   = XMAX / 2;
  Canvas    picture;
  int       bottomLeft;
  int       sideLength;
  int       degreeAngle;
  
  picture.setSize(XMAX, YMAX);
  cout << "Drawing rotated squares" << endl;
  
  // Draw rotated squares on the left-hand side using degree rotations

  bottomLeft = YMAX / 2;
  sideLength = YMAX / 4;
  picture.moveTo(bottomLeft, bottomLeft);
  
  for (degreeAngle = 0; degreeAngle < 360; degreeAngle += 45)
  {
    test("Degree angle version of drawSquare",
          drawSquare(picture, sideLength, bottomLeft, bottomLeft, degreeAngle));
  }
  
  // Draw rotated squares on the left-hand side using radian rotations

  bottomLeft += XMAX / 2;
  for (degreeAngle = 0; degreeAngle < 360; degreeAngle += 45)
  {
    test("Radians angle version of drawSquare",
          drawSquare(picture, sideLength, bottomLeft, YMAX / 2, 
                     double(DEGREES_TO_RADIANS * double(degreeAngle))) );
  }  
  
  return;
} // end testSquares2()

void testTriangles1()
{
  const int XYMAX = 200;
  Canvas    picture;
  int       bottomLeft;
  
  cout << "Drawing triangles" << endl;

  picture.setSize(XYMAX, XYMAX);
  
  // Default side length

  bottomLeft = 20;
  picture.moveTo(bottomLeft, bottomLeft);
  test("Default side length version of drawTriangle",
       drawTriangle(picture)); 
                                                 
  // Specified side lengths (right-angled)

  picture.moveTo(bottomLeft, bottomLeft + 100);
  test("Irregular side length version of drawTriangle", 
       drawTriangle(picture, 50, 120, 130)); 
       
  // Specified position

  test("Irregular side length version of drawTriangle",  
       drawTriangle(picture, 120, 130, 50, bottomLeft + 100, bottomLeft)); 

  return;
} // end testTriangles1()

void testTriangles2()
{
  const int XMAX = 250;
  const int YMAX = XMAX / 2;
  const int SIDE1 = 30;
  const int SIDE2 = 40;
  const int SIDE3 = 50;
  Canvas    picture;
  int       bottomLeft;
  int       degreeAngle;
  
  picture.setSize(XMAX, YMAX);
  cout << "Drawing rotated right-angled triangles" << endl;
  
  // Draw rotated triangles on the left-hand side using degree rotations

  bottomLeft = YMAX / 2;
  picture.moveTo(bottomLeft, bottomLeft); 
  for (degreeAngle = 0; degreeAngle < 360; degreeAngle += 45)
  {
    test("Degree angle version of drawTriangle",
          drawTriangle(picture, SIDE1, SIDE2, SIDE3,
                       bottomLeft, bottomLeft, degreeAngle) );
  }
  
  // Draw rotated triangles on the right-hand side using radian rotations

  bottomLeft += XMAX / 2;
  for (degreeAngle = 0; degreeAngle < 360; degreeAngle += 45)
  {
    test("Radians angle version of drawTriangle",
         drawTriangle(picture, SIDE1, SIDE2, SIDE3, bottomLeft, YMAX / 2, 
                      double(DEGREES_TO_RADIANS * double(degreeAngle)))   );
  }  
  
  return;
} // end testTriangles2()

void testPolygons1()
{
  const int XYMAX = 200;
  Canvas    picture;
  int       bottomLeft;
  int       sideLength;
  int       numberOfSides;
  
  cout << "Drawing Polygons" << endl;

  picture.setSize(XYMAX, XYMAX);
    
  // Default polygon

  bottomLeft = 20;
  picture.moveTo(bottomLeft, bottomLeft);
  test("Default side length version of drawRegularPolygon",
       drawRegularPolygon(picture)); 
                                                 
  // Pentagon

  numberOfSides = 5;
  picture.moveTo(bottomLeft, bottomLeft + 80);
  test("Number of sides version of drawRegularPolygon",
       drawRegularPolygon(picture, numberOfSides) ); 
       
  // Hexagon of specified side length

  numberOfSides = 8;
  sideLength    = 20;
  picture.moveTo(bottomLeft + 90, bottomLeft + 10);
  test("Specified side length version of drawRegularPolygon",
       drawRegularPolygon(picture, numberOfSides, sideLength) ); 
       
  // Dodecagon in specified position

  numberOfSides = 12;
  sideLength    = 20;
  test("Specified position version of drawRegularPolygon",
        drawRegularPolygon(picture, numberOfSides, sideLength, 
                           bottomLeft + 100, bottomLeft + 100) ); 

  return;
} // end testPolygons1()

void testPolygons2()
{
  const int XMAX          = 250;
  const int YMAX          = XMAX / 2;
  const int SIDE_LEN      = 30;
  const int NUM_SIDES     = 5;
  Canvas    picture;
  int       bottomLeft;
  int       degreeAngle;
  
  picture.setSize(XMAX, YMAX);
  cout << "Drawing rotated pentagons" << endl;
  
  // Draw rotated pentagons on the left-hand side using degree rotations

  bottomLeft = YMAX / 2;
  for (degreeAngle = 0; degreeAngle < 360; degreeAngle += 45)
  {
    test("Degree angle version of drawRegularPolygon",
         drawRegularPolygon(picture, NUM_SIDES, SIDE_LEN,
                            bottomLeft, bottomLeft, degreeAngle) );
  }
  
  // Draw rotated pentagons on the right-hand side using radian rotations

  bottomLeft += XMAX / 2;
  for (degreeAngle = 0; degreeAngle < 360; degreeAngle += 45)
  {
    test("Radians angle version of drawRegularPolygon",
         drawRegularPolygon(picture, NUM_SIDES, SIDE_LEN, bottomLeft, YMAX / 2, 
                            double(DEGREES_TO_RADIANS * double(degreeAngle)))  );
  }  
  
  return;
} // end testPolygons2()

void test(Text message, bool flag)
{
  if (!flag)
  {
    error(message);
  }
  return;
} // end test()

bool getYesOrNo(Text message)
{
  Text response;
  bool result;
  
  while (true)
  {
    cout << message << " (y/n): ";
    getline(cin, response);
    if ((response == "Y"  ) || (response == "y"  ) ||
        (response == "yes") || (response == "YES")   )
    {
      result = true;
      break;
    }
    else if ((response == "N" ) || (response == "n") ||
             (response == "no") || (response == "NO")  )
    {
      result = false;
      break;
    }
    cout << "You didn't type y or n. Please try again" << endl;
  } // end while (true)
  return result; 
} // end getYesOrNo()
