//////////////////////////////////////////////////////////////////////////
//                               squarefn.c                             //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// To draw a square using a function.                                   //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// C. Phillips       12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input required.                                                   //
// A square is drawn in a Camvas window.                                //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "Canvas.h"

void drawSquare(Canvas& picture, int sideLength);

int main()
{
  const int SIZE          = 200;
  const int STARTPOSITION = 20;
  const int SQUARESIDE    = 50;
  
  Canvas myPicture;
  
  myPicture.setSize(SIZE, SIZE);
  cout << "Drawing a square" << endl;
  
  myPicture.moveTo(STARTPOSITION, STARTPOSITION);
  drawSquare(myPicture, SQUARESIDE);
  
  cout << "Finished" << endl;
  
  return 0;
} // end main()

void drawSquare(Canvas& picture, int sideLength)
{
  // Code to draw a square
  picture.penDown();
  picture.moveRelative(sideLength, 0);
  picture.moveRelative(0, sideLength);
  picture.moveRelative(-sideLength, 0);
  picture.moveRelative(0, -sideLength);
  picture.penUp();
  return;
} // end drawSquare()

