//////////////////////////////////////////////////////////////////////////
//                              window.c                                //
// Purpose                                                              //
// =======                                                              //
// To draw a (house) window with four panes.                            //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// C. Phillips       12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input required.                                                   //
// The window is drawn on a Canvas variable.                            //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <cmath>
using namespace std;

#include "Canvas.h"
#include "error.h"

const int BORDER         = 10;
const int XYMAX          = 200;
const int PANE_SIZE      = (XYMAX - 5 * BORDER)/2;

void drawSquare(Canvas& picture, int sideLength);

int main()
{
  Canvas picture; 

  picture.setSize(XYMAX, XYMAX);
  picture.penUp();
  picture.moveTo(BORDER, BORDER);          // Move slightly
                                           //   into picture   
  drawSquare(picture, XYMAX - 2 * BORDER); // Draw outer 
                                           //   frame    
  picture.moveRelative(BORDER, BORDER);    // Move inside
                                           //   frame
  for (int pane = 0; pane < 4; pane += 1)
  {
    drawSquare(picture, PANE_SIZE);        // Draw a pane
                                           // Reposition pen
    if (pane == 0)                              // right
    {
      picture.moveRelative(PANE_SIZE + BORDER, 0);
    }
    else if (pane == 1)                        // up
    {
      picture.moveRelative(0, PANE_SIZE + BORDER); 
    }
    else if (pane == 2)                        // left
    { 
       picture.moveRelative(- (PANE_SIZE + BORDER), 0);
    }
  } // end for (...)
  return 0;
} // end main()

void drawSquare(Canvas& picture, int sideLength)
{
  // Code to draw a square
  picture.penDown();
  picture.moveRelative(sideLength, 0);
  picture.moveRelative(0, sideLength);
  picture.moveRelative(-sideLength, 0);
  picture.moveRelative(0, -sideLength);
  picture.penUp();
  return;
} // end drawSquare()


