//////////////////////////////////////////////////////////////////////////
//                              Account.h                               //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// Header file containing the interface for class Account.              //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include "State.h"

class Account
{
  public:

   // Constructor
    Account();
    
    // Member functions
    void  deposit(int amountMoney);        // Deposit some money in the account
    bool  withdraw(int howMuch);           // Withdraw amount. Return true if OK.
    int   balance();                       // Return current balance in account
    int   overdraftLimit();                // Return overdraft limit
    int   accountNumber();                 // Return number of the account
    State accountState();                  // Return account's state
    void  setOverdraftLimit(int newLimit); // Set overdraft limit
    void  setAccountNumber(int newNumber); // Set account number
    void  setAccountState(State newState); // Set state of account
    
  private:
    // Member variables
    int   number;
    int   currentBalance;
    int   maxOverdraft;
    State state;
    
    // Private member functions
    bool isInitialized();
    void accountOK();
 
};

ostream& operator<<(ostream& outStream, Account value);

