//////////////////////////////////////////////////////////////////////////
//                               structex.c                             //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// A program to grade student exam marks. It provide an example of the  //
// use of a struct and an enum.                                         //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// The program requests data for various fields in the struct.          //
// The program terminates when a 0 is given as input for the age.       //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "Text.h"

//////////////////////////////////////////////////////////////////////////
//                             PDT Definitions                          //
//////////////////////////////////////////////////////////////////////////

enum ExamGrade {PASSED, FAILED, ABSENT};

struct StudentRecord
{
  int       idNumber;
  Text      firstName;
  Text      surname;
  ExamGrade examGrade;
};

//////////////////////////////////////////////////////////////////////////
//                          Function Interfaces                         //
//////////////////////////////////////////////////////////////////////////

void grade(int examMark, StudentRecord& someone);

//////////////////////////////////////////////////////////////////////////
//                              Main Program                            //
//////////////////////////////////////////////////////////////////////////

int main()
{
  StudentRecord aPerson;
  int           mark;
  int           absences = 0;
  int           fails    = 0;
  int           passes   = 0;
  
  while (true)                      // Infinite loop, exit by a break 
  {
    cout << "Enter student details:" << endl
         << "ID number (0 to terminate the program): ";
    cin  >> aPerson.idNumber;           // Input ID number
    if (aPerson.idNumber == 0)
    {                                   // Exit if idNumber given as zero
      break;
    }
    cout << "First name: ";             // Input first name
    cin  >> aPerson.firstName;          //   of person
    cout << "Surname: ";                // Input surname
    cin  >> aPerson.surname;            //   of person
   
    mark = -1; 
    while ((mark < 0) || (mark > 100)) 
    {  
      cout << "Mark achieved in exam (0 - 100): ";
      cin  >> mark;                     // Input mark
    }
                         
    grade(mark, aPerson);               // Grade mark
                                        // Output details
    cout << endl << aPerson.firstName
         << ' '  << aPerson.surname ;
                                        // Update exam statistics and
                                        //   output person's grade
    if (aPerson.examGrade == PASSED)
    {
      cout << " has passed";
      passes += 1;
    }
    else if (aPerson.examGrade == FAILED)
    {
      cout << " has failed";
      fails += 1;
    }
    else if (aPerson.examGrade == ABSENT)
    {
      cout << " was absent from";
      absences += 1;
    }
    else
    {                                   // Defensive check
      cout << "ERROR: Unexpected value in examGrade?";
    }
    cout << " the exam" << endl << endl;
  } // end while
  
  cout << endl                          // Output exam statistics
       << "The number of absentees: " << absences << endl
       << "The number of fails:     " << fails    << endl
       << "The number of passes:    " << passes   << endl;
      
  return 0;
} // end main()

//////////////////////////////////////////////////////////////////////////
//                          Function Definition                         //
//////////////////////////////////////////////////////////////////////////

void grade(int examMark, StudentRecord& someone)
{
  if (examMark == 0)
  {
    someone.examGrade = ABSENT;
  }
  else if (examMark < 50)
  {
    someone.examGrade = FAILED;
  }
  else
  {
    someone.examGrade = PASSED;
  }
  return;
} // end grade()

