//////////////////////////////////////////////////////////////////////////
//                              Duration.h                              //
//                                                                      //
// Purpose                                                              //
// =======                                                              //
// Header file for PDT Duration                                         //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;
#include "bool.h"

class Duration
{
  public:
  
    // Constructors
                                              // Initialization value
    Duration();                               // 0:00:00
    Duration(int secs);                       // 0:00:secs
    Duration(int mins, int secs);             // 0:mins:secs
    Duration(int hours, int mins, int secs);  // hours:mins:secs
  
    // Member functions
  
    int   hours();
    int   minutes();
    int   seconds();
  
    // Member operators
          // Assignment operator provided automatically by the compiler
  
          // Arithmetic operators
  
    Duration  operator+(Duration rhs);
    Duration  operator-(Duration rhs);
    Duration  operator*(int  rhs);
    int       operator/(Duration rhs);
    Duration  operator/(int  rhs);
    Duration  operator%(Duration rhs);
  
          // Update operators
  
    Duration& operator+=(Duration rhs);
    Duration& operator-=(Duration rhs);
    Duration& operator*=(int  rhs);
    Duration& operator/=(int  rhs);
    Duration& operator%=(Duration rhs);
  
          // Comparison operators
  
    bool      operator==(Duration rhs);
    bool      operator!=(Duration rhs);
    bool      operator<=(Duration rhs);
    bool      operator>=(Duration rhs);
    bool      operator<(Duration rhs);
    bool      operator>(Duration rhs); 
  
  private:
  
    int   totalSecs;                // For systems that have 32-bit ints
    // long totalSecs;              // Use this declaration on systems that
                                    //   use 16-bit ints (e.g. PCs).
   
};

                   /////////////////////////////////
                   //   I/O Operator Interfaces   //
                   /////////////////////////////////
                   
istream& operator>>(istream&  inStream, Duration& duration);
ostream& operator<<(ostream& outStream, Duration  value);
