//////////////////////////////////////////////////////////////////////////
//                             testSquare.c                             //
// Purpose                                                              //
// =======                                                              //
// A test program for class Square                                      //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// P.A.Lee           12 December 1995                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// No input is required.                                                //
// Various patterns are drawn on Canvas instances.                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "Canvas.h"
#include "Square.h"

void test1();
void test2();
void test3();
void test4();

int main()
{
  cout << "Test program for Class Square." << endl;
  test1();
  test2();
  test3();
  test4();
  
  return 0;
} // end main()

// Test function for drawYourself

void test1()
{
  Canvas drawing;
  
  drawing.setSize(300, 300);
  
  for (int size = 280; size >= 10; size -=5)
  {
    Square square = Square(10, 10, size);
    
    square.drawYourself(drawing);
  }
} // end test1();

// Test function for rotateClockwise
// Should draw rosette
void test2()
{
  const int ANGLE = 10;
  Canvas drawing;
  Square square1 = Square(50, 50, 200);
  Square square2 = Square(100, 100, 100);
    
  drawing.setSize(300, 300);
  
  square1.drawYourself(drawing);
  square2.drawYourself(drawing);
  for (int theta = 0; theta <= 90; theta += ANGLE)
  {
    square1.rotateClockwise(ANGLE);
    square1.drawYourself(drawing);
    square2.rotateClockwise(ANGLE);
    square2.drawYourself(drawing);
  }
} // end test2();

// Test function for moveCenter and setSize
void test3()
{
  Canvas drawing;
  Square sq;
  const double ANGLE = 10.0;
  
  drawing.setSize(400, 300);
  
  sq.moveCenter(drawing.sizeX()/2, drawing.sizeY()/2);
  
  for (int size = drawing.sizeY() - 100; size > 10; size -= 4)
  {
    sq.setSize(size);
    sq.drawYourself(drawing);
    sq.rotateClockwise(ANGLE);
    sq.setSize(size);
  }
} // end test3()

// Test function for moveRelative and moveCenter
void test4()
{
  Canvas drawing;
  const int SIZE    = 10;
  const int START_X = 50;
  const int START_Y = 80;
  Square sq;
  
  drawing.setSize(150, 120);
  
  sq.setSize(SIZE);
  sq.moveCenter(START_X, START_Y);
  sq.drawYourself(drawing);
  sq.moveRelative(50, 0);
  sq.drawYourself(drawing);
  sq.moveRelative(-25, -(SIZE/2));
  for (int nose = 0; nose < 3; nose += 1)
  {
    sq.drawYourself(drawing);
    sq.moveRelative(0, -SIZE);
  }
  sq.moveRelative (-20, -(SIZE/2));
  sq.drawYourself(drawing);
  sq.moveRelative((SIZE/2), -SIZE);
  for (int mouth = 0; mouth < 4; mouth += 1)
  {
    sq.drawYourself(drawing);
    sq.moveRelative(SIZE, 0);
  }
  sq.moveRelative(-(SIZE/2), SIZE);
  sq.drawYourself(drawing);

} // end test4()

 
  
  
