//////////////////////////////////////////////////////////////////////////
//                              CompassPoint.c                          //
// Purpose                                                              //
// =======                                                              //
// Implementation file for the CompassPoint PDT with input check        //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// C. Phillips       16 November 1998                                   //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "CompassPoint.h"
#include "Text.h"

istream& operator >> (istream& inStream,  CompassPoint& forInput)
{
  Text input;
  if (inStream.good())
  {
    inStream >> input;
    if (inStream.good())
    {
      if (input == "NORTH")
      {
        forInput = NORTH;
      }
      else if (input == "SOUTH")
      {
        forInput = SOUTH;
      }
      else if (input == "WEST")
      {
        forInput = WEST;
      }
      else if (input == "EAST")
      {
        forInput = EAST;
      }
      else
      {
        inStream.clear(ios_base::failbit);
      }
    }
  }
  return inStream;
}

ostream& operator << (ostream& outStream, CompassPoint value)
{
  switch (value)
  {
    case NORTH:
      {
        outStream << "NORTH";
      }
      break;
    case SOUTH:
      {
        outStream << "SOUTH";
      }
      break;
    case WEST:
      {
        outStream << "WEST";
      }
      break;
    case EAST:
      {
        outStream << "EAST";
      }
      break;
    default:
      {
        outStream << "Unknown CompassPoint value";
      }
      break;
  }
  return outStream;
}