//////////////////////////////////////////////////////////////////////////
//                              Main.c                                  //
// Purpose                                                              //
// =======                                                              //
// To test the CompassPoint I/O operators                               //
//                                                                      //
// Author            Creation Date                                      //
// ======            =============                                      //
// C. Phillips       16 November 1998                                   //
//                                                                      //
// Input/Output                                                         //
// ============                                                         //
// Input should consist of a sequence of CompassPoint literal values,   //
// with a 'Y' or 'y' indicating that the sequence is to continue.       //
// For each CompassPoint value input, that value will be output,        //
// unless the value is invalid, in which case an error message is       //
// produced                                                             //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include <iostream>
using namespace std;

#include "CompassPoint.h"

int main()
{
  char carryOn = 'Y';
  CompassPoint point = NORTH;
  
  while ((carryOn == 'Y') || (carryOn == 'y'))
  {
    cout << "Please supply a CompassPoint value: ";
    cin >> point;
    if (!cin.good())
    {
      cout << endl << "Invalid input attempted of CompassPoint value" << endl;
      cin.clear();
    }
    else
    {
      cout << "Read " << point << endl;
    }
    cout << endl
         << "Type 'Y' or 'y' to input another CompassPoint value." << endl
         << "Any other character to terminate: ";
    cin  >> carryOn;
  }
  return 0;
}