# acid96 examples - interrupt handler - model 5 (low power-ish)
# this model has a joint control (locally set and globally reset) of signal b
# this model has two one bit interrupt record units
.model acid_interrupt.5.g
.inputs a1 a2 cr br r  g11 g12 g21 g22 
.outputs bk ck t1 t2 tg b1 b2 bin bout1 r11 r12 bout2 bout r21 r22 g2t  s1 s2
.dummy dum11_1 dum11_2 dum12_1 dum12_2 dum13 dum111 dum112 dum21_1 dum21_2 dum22_1 dum22_2 dum23 dum211 dum212
.graph


# ====================================================================
# bit recorder 1
# ====================================================================
# part a1

a1+ r11+/1
r11+/1 g11+/1
g11+/1 p11_1
p11_1 dum11_1 t1+/1
dum11_1 p13_1
t1+/1 p12_1
p12_1 dum12_1 tg+/11
dum12_1 p13_1
tg+/11 p13_1
p13_1 s1+
s1+ r11-/1 
r11-/1 g11-/1
g11-/1 a1-

a1- r11+/2
r11+/2 g11+/2
g11+/2 p11_2
p11_2 dum11_2 t1+/2
dum11_2 p13_2
t1+/2 p12_2
p12_2 dum12_2 tg+/12
dum12_2 p13_2
tg+/12 p13_2
p13_2 s1-
s1- r11-/2 
r11-/2 g11-/2
g11-/2 a1+

# connections b/w part a1 and shared part

me1 g11+/1
g11-/1 me1
me1 g11+/2
g11-/2 me1
t10 t1+/1
t1+/1 t11
t10 t1+/2
t1+/2 t11
t11 dum11_1
dum11_1 t11
t11 dum11_2
dum11_2 t11
tg0 tg+/11
tg+/11 tg1
tg0 tg+/12
tg+/12 tg1
tg1 dum12_1
dum12_1 tg1
tg1 dum12_2
dum12_2 tg1


#local part b1 and r1
p101 bin+ r+

# local part b1
bin+ r12+/1
r12+/1 g12+/1
g12+/1 p14
p14 bout1+/1 b1+
bout1+/1 p19 BOUT11
p19 bin-/11 bin-/12
bin-/11 p15 p16
bin-/12 p15 p16
b1+ bout1+/2
bout1+/2 p110 b1- BOUT12
p110 bin-/21 bin-/22
bin-/21 p1100
bin-/22 p1100
p1100 t1-/1
t1-/1 TG11
TG11 tg-/11 dum111
tg-/11 TG12
dum111 TG12
TG12 b1- 
b1- p15 p16
p16 bout1-
#p15 r12-/1
#r12-/1 g12-/1
#g12-/1 bout1-
#bout1- p101 BOUT13
#slow down a bit the reset of mutex until bout-
p15 bout1-
bout1- p101 BOUT13 bout-
bout- r12-/1
r12-/1 g12-/1



# connections b/w local part b1 and shared part
me1 g12+/1
g12-/1 me1
t10 bout1+/1
bout1+/1 t10
t11 b1+
t1-/1 t10
tg1 tg-/11
tg-/11 tg0
t20  tg-/11
tg-/11 t20
tg0 dum111
dum111 tg0

# part r1
r+ r12+/2
r12+/2 g12+/2
g12+/2 p17
p17 dum13 t1-/2
dum13 p18
t1-/2 TG13
TG13 tg-/12 dum112
tg-/12 p18
dum112 p18
p18 r-
r- r12-/2
r12-/2 g12-/2
g12-/2 p101

# connections b/w part r1 and shared part
me1 g12+/2
g12-/2 me1
t10 dum13
dum13 t10
t11 t1-/2
t1-/2 t10
tg1 tg-/12
tg-/12 tg0
t20 tg-/12
tg-/12 t20
tg0 dum112
dum112 tg0

# ====================================================================
# bit recorder 2
# ====================================================================
# part a2

a2+ r21+/1
r21+/1 g21+/1
g21+/1 p21_1
p21_1 dum21_1 t2+/1
dum21_1 p23_1
t2+/1 p22_1
p22_1 dum22_1 tg+/21
dum22_1 p23_1
tg+/21 p23_1
p23_1 s2+
s2+ r21-/1 
r21-/1 g21-/1
g21-/1 a2-

a2- r21+/2
r21+/2 g21+/2
g21+/2 p21_2
p21_2 dum21_2 t2+/2
dum21_2 p23_2
t2+/2 p22_2
p22_2 dum22_2 tg+/22
dum22_2 p23_2
tg+/22 p23_2
p23_2 s2-
s2- r21-/2 
r21-/2 g21-/2
g21-/2 a2+

# connections b/w part a2 and shared part

me2 g21+/1
g21-/1 me2
t20 t2+/1
t2+/1 t21
t21 dum21_1
dum21_1 t21
tg0 tg+/21
tg+/21 tg1
tg1 dum22_1
dum22_1 tg1
me2 g21+/2
g21-/2 me2
t20 t2+/2
t2+/2 t21
t21 dum21_2
dum21_2 t21
tg0 tg+/22
tg+/22 tg1
tg1 dum22_2
dum22_2 tg1


#local part b2 and r2
p201 bin+ r+

# local part b2
bin+ r22+/1
r22+/1 g22+/1
g22+/1 p24
p24 bout2+/1 b2+
bout2+/1 p29 BOUT21
p29 bin-/11 bin-/21
bin-/11 p25 p26
bin-/21 p25 p26
b2+  bout2+/2
bout2+/2 p210 b2- BOUT22
p210 bin-/12 bin-/22
bin-/12 p2100
bin-/22 p2100
p2100 t2-/1
t2-/1 TG21
TG21 tg-/21 dum211
tg-/21 TG22
dum211 TG22
TG22 b2-
b2- p25 p26
p26 bout2-
#p25 r22-/1
#r22-/1 g22-/1
#g22-/1 bout2-
#bout2- p201 BOUT23
#slow down a bit the reset of mutex until bout-
p25 bout2-
bout2- p201 BOUT23 bout-
bout- r22-/1
r22-/1 g22-/1


# connections b/w local part b1 and shared part
me2 g22+/1
g22-/1 me2
t20 bout2+/1
bout2+/1 t20
t21 b2+
t2-/1 t20
tg1 tg-/21
tg-/21 tg0
t10  tg-/21
tg-/21 t10
tg0 dum211
dum211 tg0

# part r2
r+ r22+/2
r22+/2 g22+/2
g22+/2 p27
p27 dum23 t2-/2
dum23 p28
t2-/2 TG23
TG23 tg-/22 dum212
tg-/22 p28
dum212 p28
p28 r-
r- r22-/2
r22-/2 g22-/2
g22-/2 p201


# connections b/w part r2 and shared part
me2 g22+/2
g22-/2 me2
t20 dum23
dum23 t20
t21 t2-/2
t2-/2 t20
tg1 tg-/22
tg-/22 tg0
t10 tg-/22
tg-/22 t10
tg0 dum212
dum212 tg0

# synchronisation of bout1 and bout2

BOUT11 bout+/11 bout+/12 
BOUT12 bout+/21 bout+/22
BOUT21 bout+/11 bout+/21
BOUT22 bout+/12 bout+/22

BOUT13 bout-
BOUT23 bout-


p302 br+ cr+ r+
r+ r-
r- p302

br+ bin+
bin+ p310
p310 bout+/11 bout+/21 bout+/12 bout+/22
bout+/11 bk+/11
bout+/21 bk+/21
bout+/12 bk+/12
bout+/22 bk+/22
bk+/11 bin-/11 br-/11
bk+/21 bin-/21 br-/21
bk+/12 bin-/12 br-/12
bk+/22 bin-/22 br-/22
bin-/11 p311
bin-/12 p311
bin-/21 p311
bin-/22 p311
br-/11 p312
br-/21 p312 RESb1
br-/12 p312 RESb2
br-/22 p312 RESb1 RESb2
p312 bk-
p311 bout-
bout- bk-
bk- p302

cr+ ck+
ck+ cr-
cr- ck-
ck- p302

#synchronisation of g2's

g12+/1 pg11
g12+/2 pg11
g22+/1 pg21
g22+/2 pg21
pg11 g2t+
pg21 g2t+
g2t+ pg2
pg2 bk+/11 bk+/12 bk+/21 bk+/22 r-
g12-/1 pg13
g12-/2 pg13
g22-/1 pg23
g22-/2 pg23
pg13 g2t-
pg23 g2t-
g2t- pg4
pg4 bin+ r+



# connections b/w global part and shared part

tg1 ck+
ck+ tg1
#tg0 bk+/11 bk+/12 bk+/21 bk+/22  
#bk+/11 tg0
#bk+/12 tg0
#bk+/21 tg0
#bk+/22 tg0
tg0 bout-
bout- tg0

RESb1 b1-
RESb2 b2-

.marking { <g11-/2,a1+>  <g21-/2,a2+> me1 t10 me2 t20 tg0 p101 p201 p302 pg4 }
.end
