/* Examples of mixing types */
#include <stdio.h>
#include <math.h>
/*it is legal to mix integers and floating point values
to assign a floating point value to an integer, or an
integer to a floating point value */

int main (void)
{
  long int i,j;
  float x,y;
  /*the next part of the program looks at implicit conversions */
  i = 11;
  x = i;
  printf("x is %f\n",x);
  /*the integer 11 is mapped to the floating point 11.000000 */
  x = 3.7415;
  i = x;
  printf("i is %i\n",i);
  /*the floating point number is 3, it is the modulus i.e. no rounding */
    
  /*the next part of the example looks at explicit conversions */
  /*explicit conversion is called casting */
  x = (float) 6; 
  /*converts 6 to a floating point before assigning it to x */
  printf("X is a floating point variable\n");
  printf("X in floating point format = %f\n",x);
  printf("X in integer format= %i\n",x);
  i = (float) 6;
  printf("I is an integer variable\n");
  printf("I in integer format %i\n",i);
  /* 6 is converted to floating point, but converted back again
  when assigned to i */
  printf("I in floating point format %f\n",i);
  
  /*lets look at why casting is necessary */
  i = 3; j = 2;
  x = i/j;
  printf("3/2 without casting = %f\n",x);
  /*the result is 3/2 = 1.000000, because i/j only involves
  integers and an integer result is produced i.e. 1.000000 */
  x = (float) i/j;
  /* i has been explicitly converted to floating point. implicit
  conversion then makes j a floating point too */
  printf("3/2 with casting = %f\n",x); 
    
}
