/* This example looks at file handling*/

/*C makes no distinction between devices. IO is performed through
streams, that consist of an ordered series of bytes */
/* The file position indicator where the next byte come from */
/* Each program has standard streams stdin, stdout and stderr */
/* Data can be text or binary */
/* Input / output is typically buffered in blocks of 512 or 1024
bytes. C can use either block buffering or line buffering in
which a newline stops the buffering. The buffer can be explicitly
flushed with the fflush() function. */

#include <stddef.h>
#include <stdio.h> /* contains the file structure (file pointer)*/
#include <string.h>
#define MAXLINELENGTH 70
int error = 0; /* global variable */

FILE *openfile(char *filename, char *mode) 
/*Opens a file and returns a pointer to it */
{  /*NB compiler is case sensitive need FILE not file */
  FILE *fp;
  fp = fopen(filename,mode); /* file name, access type (see below) */
  if (fp == NULL)
  { fprintf(stderr,"Error opening file %s with mode %s \n",
            filename,mode); 
    error = 1;
  } else printf("File %s opened OK\n",filename);
  return fp;
}

void write_file(FILE *f)
/*writes out the contents of the file to the terminal */
{
  char line[MAXLINELENGTH];
  while (fgets (line,MAXLINELENGTH-1,f) != NULL)
  {
    printf("%s\n",line);
  }
}

int main (void)
{
  FILE *f;
  char naym[20];
  printf("Which file would you like to read? ");
  scanf("%s",&naym); printf("\n");
  f = openfile(naym,"r");
  if (error == 0) write_file(f);
}

/*file access modes
 "r"  open an existing text file for reading
 "w"  open a new text file for writing
 "a"  open an existing text file. Can only write at the end
 "r+" open existing text file for reading and writing, starts at begining
 "w+" open existing text file for r/w if file exists it is truncated to 0
 "a+" open an existing file for r/w access, can read anywhere, but only
      write at the end of the file
  NB binary modes are rb,wb, ab etc.
*/

/* I/O operations can occur:
- one character at a time
- one line at a time
- one block at a time

One character at a time functions
---------------------------------
getc() 	a macro that reads one character from a stream
fgetc()	a function that reads one character at a time
Syntax: int fgetc (FILE *stream);
putc() 	a macro that writes one character into a stream
fputc() a function that writes one character to a stream
Syntax: int fputc (int c; FILE *stream);
One line at a time functions
----------------------------
fgets() reads until it gets to a newline, eof or null character. 
Syntax: int fgets(FILE *stream);
It puts a null character at the end of the array. The syntax is:
char *fgets(char *s,int n, FILE of stream); (n = max no. characters)
gets()  reads from standard input. It does not add the null character.
It does not allow the maximum number of characters to be specified.

*/

