/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

class DirectedEdge
{
    private Edge    m_edge;
    private boolean m_aligned;

    public DirectedEdge (Edge e, boolean aligned)
    {
	m_edge = e;
	m_aligned = aligned;
    }

    public Vertex v1 ()
    {
	return m_aligned ? m_edge.v1 () : m_edge.v2 ();
    }
    public Vertex v2 ()
    {
	return m_aligned ? m_edge.v2 () : m_edge.v1 ();
    }
    public Edge edge()
    {
	return m_edge;
    }

    public boolean aligned ()
    {
	return m_aligned;
    }
     public int get_iges_edge_index()
    {
	return m_edge.get_iges_edge_index();
    }
}