/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

class DirectoryEntry
	{
	
	    private ParameterData m_Data;

		// Identifies the entity type.
		// int	m_Number;                // integer

		// Pointer to the first line of the parameter data record for
		// the entity. The letter P is not included.
		// int	m_ParameterData;         // pointer

		// Negated pointer to the directory entry of the definition
		// entity that specifies this entity's meaning, or zero (default).
		// The letter D is not included.
	    private int m_Structure;             // integer or pointer

		// Line font pattern number, or negated pointer to the Directory
		// Entry of a Line Font Definition Entity (Type 304), or
		// zero (default).
	    private int m_LineFontPattern;       // integer or pointer

		// Number of the level upon which the entity resides, or a
		// negated pointer to the Directory Entry of a Definition Levels
		// Property Entity (Type 406, Form 1), or zero (default).
		private int m_Level;                 // integer or pointer

		// Pointer to the Directory Entry of a View Entity (Type
		// 410), pointer to a Views Visible Associativity Instance
		// (Type 402, Form 3,4, or 19 ), or zero (default).
		private int m_View;                  // pointer or 0

		// Pointer to the Directory Entry of a Transformation Matrix
		// Entity (Type 124) used in defining this entity or zero
		// (default).
		private int m_TransformationMatrix;  // pointer or 0

		// Pointer to the Directory Entry of a label Display Associativity
		// (Type 402, Form 5), or zero (default).
		private int m_LabelDisplayAssoc;     // pointer or 0

		// Comprises four two-digit values which are concatenated in
		// the order listed into a single 8-digit number which fills the
		// field; no space characters are allowed.
		//   1-2 Blank Status
		//     00 Visible
		//     01 Blanked
		//   3-4 Subordinate Entity Switch
		//     00 Independent
		//     01 Physically Dependent
		//     02 Logically Dependent
		//     03 Both (01) and (02)
		//   5-6 Entity Use Flag
		//     00 Geometry
		//     01 Annotation
		//     02 Definition
		//     03 Other
		//     04 Logical/Positional
		//     05 2D Parametric
		//     06 Construction geometry
		//   7-8 Hierarchy
		//     00 Global top down
		//     01 Global defer
		//     02 Use hierarchy property
	    public char m_StatusNumber[] = new char[9];          // integer
	    	    
	    private StatusVisible m_sv = StatusVisible.sv_Visible;
	    
	    private StatusSubordinate m_ss = StatusSubordinate.ss_Independent;

	    private StatusEntity m_se = StatusEntity.se_Geometry;

	    private StatusHierarchy m_sh = StatusHierarchy.sh_GlobalTopDown;

	    void set_visible (StatusVisible sv)
	    {
		m_sv = sv;
		m_StatusNumber[0] = '0';
		m_StatusNumber[1] = sv.getvalue ();
	    }
	    StatusVisible visible () { return m_sv; }
	    
	    void set_subordinate (StatusSubordinate ss)
	    {
		m_ss = ss;
		m_StatusNumber[2] = '0';
		m_StatusNumber[3] = ss.getvalue ();
	    }
	    StatusSubordinate subordinate () { return m_ss; }
	    
	    void set_entity (StatusEntity se)
	    {
		m_se = se;
		m_StatusNumber[4] = '0';
		m_StatusNumber[5] = se.getvalue ();
	    }
	    StatusEntity entity () { return m_se; }

	    void set_hierarchy (StatusHierarchy sh )
	    {
		m_sh = sh;
		m_StatusNumber[6] = '0';
		m_StatusNumber[7] = sh.getvalue ();
	    }
	    StatusHierarchy hierarchy () { return m_sh; }

	    private void init_status ()
		{
			set_visible (StatusVisible.sv_Visible);
			set_subordinate (StatusSubordinate.ss_Independent);
			set_entity (StatusEntity.se_Geometry);
			set_hierarchy (StatusHierarchy.sh_GlobalTopDown);

			m_StatusNumber[8] = 0;
		}
	    
	    // System display thickness; given as a gradation value in the
	    // range of 0 to the maximum (Parameter 16 of the Global
	    // Section).
	    int m_LineWeightNumber;      // integer

	    // Color number or negated pointer to the Directory Entry
	    // of a Color Definition Entity (Type 314), or zero (default).
	    int m_ColorNumber;           // integer or pointer
	    
	    public void set_color (int c)
	    {
		m_ColorNumber = c;
	    }

	    // Quantity of lines in the parameter data record for this
	    // entity.
	    // int	m_ParameterLineCount;    // integer
	    
	    // Form number for entities having more than one interpretation
	    // of their parameter values, or zero (default). Entity
	    // form numbers are included within each entity's description.
	    int m_FormNumber;            // integer
	    
	    // Up to eight alphanumeric characters (right justified), or
	    // NULL (default).
	    // Entity Label
	    
	    // 1 to 8 digit unsigned number associated with the entity
	    // label.
	    int m_EntitySubscriptNumber; // integer
	    
	    int m_SequenceNumber;    // integer
	    
	    String m_sequence1,m_sequence2;

	    public DirectoryEntry (int entity_number, int form_number, int sequence_number) {
		m_Data = new ParameterData(entity_number);
		m_Structure = 0;
		m_LineFontPattern = 0;
		m_Level = 0;
		m_View = 0;
		m_TransformationMatrix = 0;
		m_LabelDisplayAssoc = 0;
		m_LineWeightNumber = 0;
		m_ColorNumber = 0;
		m_FormNumber = form_number;
		m_EntitySubscriptNumber = 0;
		m_SequenceNumber = sequence_number;

		m_sequence1 = new String();
		m_sequence1 = new String();

		init_status ();
	    }
	    
	    public ParameterData data () { return m_Data; }
	    
	    public int entity_number () { return m_Data.entity_number (); }
	    public int form_number () { return m_SequenceNumber; }
	    public int sequence_number (){ return m_SequenceNumber; }
	    
	    public String record_line_1 () { return m_sequence1; }
	    public String record_line_2 () { return m_sequence2; }
	    
	    void build_sequence ()
	    {
	      	m_sequence1 = String.format("%8d%8d%8d%8d%8d%8d%8d%8d",
						  m_Data.entity_number (),
						  m_Data.sequence_number (),
						  m_Structure,
						  m_LineFontPattern,
						  m_Level,
						  m_View,
						  m_TransformationMatrix,
						  m_LabelDisplayAssoc);
		m_sequence1 += new String (m_StatusNumber,0,8);

		m_sequence2 =String.format( "%8d%8d%8d%8d%8d%32d",
						m_Data.entity_number (),
						m_LineWeightNumber,
						m_ColorNumber,
						m_Data.parameter_line_count (),
						m_FormNumber,
						m_EntitySubscriptNumber);
	    }
}
