/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

public class Edge{

    private Vertex v1;
    private Vertex v2;

    private int edge_seq_no;
    private int iges_edge_index;

    private int m_edge_count;

    private boolean m_bIntersects;
    private boolean m_bInternal;
    private boolean m_bExternal;
    private Vertex  m_Intersection = null;
    
    public Edge (Vertex a, Vertex b)
    {
	int a_vid = a.vid ();
	int b_vid = b.vid ();

	if (a_vid < b_vid)
	    {
		v1 = a;
		v2 = b;
	    }
	else
	    { 
		v1 = b;
		v2 = a;
	    }
    }

    public Vertex v1 ()
    {
	return v1;
    }
    public Vertex v2 ()
    {
	return v2;
    }
    public void set_iges_line_de_seqno (int n)
    {
	edge_seq_no = n;
    }
    public int get_iges_line_de_seqno ()
    {
	return edge_seq_no;
    }
    public void set_iges_edge_index (int j)
    {
	iges_edge_index = j;
    }
    public int get_iges_edge_index ()
    {
	return iges_edge_index;
    }

    public void set_internal (boolean bInternal)
    {
	m_bInternal = bInternal;
    } 
    public boolean get_internal ()
    {
	return m_bInternal;
    }

    public void set_external (boolean bExternal)
    {
	m_bExternal = bExternal;
    }
    public boolean get_external ()
    {
	return m_bExternal;
    }
    
    public void set_intersects (boolean bIntersects)
    {
	m_bIntersects = bIntersects;
    }
    public boolean get_intersects ()
    {
	return m_bIntersects; 
    }
    public void set_intersection (Vertex Vi)
    {
	m_Intersection = Vi;
    }
    public Vertex get_intersection ()
    {
	return m_Intersection;
    }
    public void count_clear ()
    {
	m_edge_count = 0;
    }
    public void count_increment ()
    {
	m_edge_count++;
    }
    public int count ()
    {
	return m_edge_count;
    }
}
