/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.lang.*;
import java.util.*;

public class EdgeKey implements Comparable
{
    private Vertex m_v1;
    private Vertex m_v2;

    private boolean m_aligned;

    public EdgeKey (Vertex a, Vertex b)
    {
	int a_vid = a.vid ();
	int b_vid = b.vid ();

	if (a_vid < b_vid)
	    {
		m_v1 = a;
		m_v2 = b;
		m_aligned = true;
	    }
	else
	    {
		m_v1 = b;
		m_v2 = a;
		m_aligned = false;
	    }
    }

    public Vertex v1 ()
    {
	return m_v1;
    }
    public Vertex v2 ()
    {
	return m_v2;
    }

    public int vid1 ()
    {
	return m_v1.vid ();
    }
    public int vid2 ()
    {
	return m_v2.vid ();
    }

    public int compareTo (Object o)
    {
	EdgeKey rhs = (EdgeKey) o;

	if (m_v1.vid () < rhs.vid1 ())
	    {
		return -1;
	    }
	if ((m_v1.vid () == rhs.vid1 ()) && (m_v2.vid () < rhs.vid2 ()))
	    {
		return -1;
	    }
        if ((m_v1.vid () == rhs.vid1 ()) && (m_v2.vid () == rhs.vid2 ()))
	    {
		return 0;
	    }
	return 1;
    }

    public boolean aligned ()
    {
	return m_aligned;
    }
}