/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.util.*;

class FacetPair
{
    private String m_fid = null;

    private Facet  m_f1 = null;
    private Facet  m_f2 = null;

    private float m_r;
    private float m_g;
    private float m_b;

    public FacetPair (Facet f, float r, float g, float b)
    {
	m_f1  = f;
	m_fid = f.get_ID ();

	m_r = r;
	m_g = g;
	m_b = b;
    }

    public String get_ID ()
    {
	return m_fid;
    }

    public Facet f1 ()
    {
	return m_f1;
    }
    public Facet f2 ()
    {
	return m_f2;
    }

    public float color_r ()
    {
	return m_r;
    }
    public float color_g ()
    {
	return m_g;
    }
    public float color_b ()
    {
	return m_b;
    }

    public void add_pair (Facet f, float r, float g, float b)
    {
	m_f2 = f;

	m_r = (m_r + r) / 2.0f; // blend the colors
	m_g = (m_g + g) / 2.0f;
	m_b = (m_b + b) / 2.0f;
    }

    public boolean is_paired ()
    {
	return (m_f2 != null);
    }

    public double area ()
    {
	return m_f1.area ();
    }

    /* This will of course be the wrong direction for the paired facet...
     */
    public final Vector<Vertex> vertices ()
    {
	return m_f1.vertices ();
    }
    public float normal_xf ()
    {
	return m_f1.normal_xf ();
    }
    public float normal_yf ()
    {
	return m_f1.normal_yf ();
    }
    public float normal_zf ()
    {
	return m_f1.normal_zf ();
    }

    public boolean in_plane (double offset, PlaneCompare pc)
    {
	boolean bInPlane = true;

	Vector<Vertex> vertices = m_f1.vertices ();

	int count = vertices.size ();

	for (int i = 0; i < count; i++)
	    {
		Vertex v = vertices.elementAt (i);

		if (!pc.is_internal (offset, v) || !pc.is_external (offset, v))
		    {
			bInPlane = false;
			break;
		    }
	    }
	return bInPlane;
    }
}
