/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.lang.*;
import java.util.*;


public class Parameter{

    public static String str_lG (double value)
    {
	return Double.toString (value);
    }
    public static String str_ld (long value)
    {
	return Long.toString (value);
    }
    public static String str_HS (String value)
    {
	Integer length = new Integer (value.length ());
	return length.toString () + "H" + value;
    }

    private String m_Parameter;
    private boolean m_bNumeric;
    
    public Parameter ()
    {
	m_Parameter = new String ();
	m_bNumeric = false;
    }
    public Parameter (String parameter, boolean bNumeric)
    {
	m_Parameter = parameter;
	m_bNumeric = bNumeric;
    }
    public String  parameter()
    {
	return m_Parameter;   
    }
    
    public boolean bNumeric()
    {
	return m_bNumeric;
    }
    

    public void set (String parameter, boolean bNumeric)
    {
	m_Parameter = parameter;
	m_bNumeric = bNumeric;
    }
    public void set_lG(double value)
    {
	set (str_lG(value),true);
    }
    public void set_ld (long value)
    {
	set (str_ld ( value ),true);
    }
    
    public void set_HS (String value)
    {    
	set (str_HS(value),false);
    }
    
}



