/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.lang.*;
import java.util.*;
import java.lang.String.*;

public class ParameterData
{
    private int m_Number;
    private int m_SequenceNumber;
    private int m_ParameterLineCount;
    private String m_line_buffer;
    private Vector m_parameter;
    private Vector m_sequence;
   
    public ParameterData ( int entity_number )
    {
	m_Number = entity_number;
	m_SequenceNumber = 0;
	m_ParameterLineCount = 1;
	m_line_buffer = new String();
	m_parameter = new Vector();
	m_sequence = new Vector();
    }
    
    public int entity_number (){
	return m_Number;
    }
    public int sequence_number (){
	return m_SequenceNumber;
    }
    public int parameter_line_count()
    {
	return m_ParameterLineCount;
    }
    public Vector sequence(){
	return m_sequence;
    }
    
    public void append ( String parameter , boolean bNumeric )
    {
	m_parameter.addElement (new Parameter(parameter,bNumeric));
    }
    public void append_lG (double value) {
	append (Parameter.str_lG(value), true);
    }
    public void append_ld (int value){
	append (Parameter.str_ld(value), true);
    }
    public void append_lu ( int value )
    {
	append (Parameter.str_ld(value),true);
    }
    public void append_HS(String value)
    {
	append(Parameter.str_HS(value),false);
    }
    public int build_sequence (int de_seqno, int pd_seqno)
    {
	m_sequence.clear ();
	
	m_line_buffer = String.format( "%d,",m_Number);

       	int buffer_offset = m_line_buffer.length();
	
	int count = m_parameter.size();
	
	for (int i = 0; i < count; i++)
	    {
		String delim = ((i + 1) == count) ? ";" : ",";
		
		Parameter GP = (Parameter) m_parameter.get(i);
		
		int length = GP.parameter().length ();
	       	int offset = 0;
		
		if (buffer_offset + length < 64)
		    {
			m_line_buffer = m_line_buffer.concat (GP.parameter());
			m_line_buffer = m_line_buffer.concat (delim);
			buffer_offset += length + 1;
			continue;
		    }
		if (GP.bNumeric ())
		    {
			append_sequence (de_seqno, buffer_offset);
			m_line_buffer = GP.parameter();
			m_line_buffer = m_line_buffer.concat (delim);
			buffer_offset = length + 1;
			continue;
		    }
		while (offset < length)
		    {
			if ((length - offset) <= (64 - buffer_offset))
			    {
				m_line_buffer = m_line_buffer.concat ((GP.parameter()).substring(offset));
				buffer_offset += length - offset;
				offset = length;
			    }
			else
			    {
				int copy_length = 64 - buffer_offset;
				m_line_buffer = m_line_buffer.concat ((GP.parameter()).substring(offset,offset+copy_length));
				offset += copy_length;
				buffer_offset += copy_length;
			    }
			if (buffer_offset == 64)
			    {
				append_sequence (de_seqno, buffer_offset);
				m_line_buffer = "";
				buffer_offset = 0;
			    }
		    }
		m_line_buffer = m_line_buffer.concat (delim);
		buffer_offset++;
	    }
	if (buffer_offset > 0)
	    append_sequence (de_seqno, buffer_offset);
	
	m_ParameterLineCount = m_sequence.size();
	m_SequenceNumber = pd_seqno;

	return m_SequenceNumber + m_ParameterLineCount;
    }

    public void append_sequence (int de_seqno, int offset)
    {
	while (offset < 65)
	    {
		m_line_buffer = m_line_buffer.concat (" ");
		offset++;
	    }
	m_line_buffer = m_line_buffer.concat (String.format ("%7d", de_seqno));

	m_sequence.addElement (new String (m_line_buffer));
    }
}
