/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import javax.swing.Action;

import java.beans.PropertyChangeListener;

import java.awt.event.ActionEvent;

public class RegionAction implements Action
{
    private RegionFrameListener  m_frame  = null;
    private ActionType           m_action;

    private String m_name = null;

    public RegionAction (RegionFrameListener frame, ActionType action)
    {
	m_frame  = frame;
	m_action = action;

	switch (m_action)
	    {
	    case OPEN:
		m_name = "Open...";
		break;
	    case SAVE:
		m_name = "Save...";
		break;
	    case IGES:
		m_name = "Export IGES...";
		break;
	    }
    }

    public void addPropertyChangeListener (PropertyChangeListener listener)
    {
	// Adds a PropertyChange listener.
    }

    public Object getValue (String key)
    {
	if (key == Action.NAME)
	    return m_name;

	// Gets one of this object's properties using the associated key.
	return null;
    }

    public boolean isEnabled ()
    {
	// Returns the enabled state of the Action.
	return true;
    }

    public void putValue (String key, Object value)
    {
	// Sets one of this object's properties using the associated key.
    }

    public void removePropertyChangeListener (PropertyChangeListener listener)
    {
	// Removes a PropertyChange listener.
    }

    public void setEnabled (boolean b)
    {
	// Sets the enabled state of the Action.
    }

    public void actionPerformed (ActionEvent e)
    {
	// Invoked when an action occurs.
	switch (m_action)
	    {
		case OPEN:
		    m_frame.open ();
		    break;
		case SAVE:
		    m_frame.save ();
		    break;
		case IGES:
		    m_frame.export_IGES ();
		    break;
	    }
    }
}
