/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.awt.*;
import javax.swing.*;
import javax.media.opengl.GLCanvas;

public class RegionApplet extends JApplet
{
    private RegionCanvas m_canvas = null;
    
    public void init() 
    {
	String xml_data_uri = getParameter ("RegionReader.xml_data_uri");
	String transparency = getParameter ("RegionReader.transparency");

	if (xml_data_uri != null)
	    {
		RegionLoader loader = RegionLoader.load_uri (xml_data_uri);
		if (loader != null)
		    {
			m_canvas = new RegionCanvas (loader);
			getContentPane().add (m_canvas.canvas (), java.awt.BorderLayout.CENTER);

			if (transparency != null)
			    if (transparency.compareToIgnoreCase ("true") == 0)
				m_canvas.set_transparent (true);
		    }
	    }
    }
    public void start()
    {
	if (m_canvas != null)
	    m_canvas.start_animation();
    }
    public void stop()
    {
	if (m_canvas != null)
	    m_canvas.stop_animation();
    }
    public void destroy()
    {
	m_canvas = null;
    }
}
