/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import javax.media.opengl.GLCanvas;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JMenuBar;

import com.sun.opengl.util.Animator;

import java.awt.FileDialog;

import java.io.File;
import java.io.FilenameFilter;

import java.util.Vector;

public class RegionFrame extends JFrame implements RegionFrameListener, FilenameFilter
{
    private RegionReaderListener m_reader = null;
    private RegionLoader         m_loader = null;
    private ActionType           m_action;

    private RegionCanvas m_canvas = null;

    private JMenuBar menu = null;

    private float rotateX = 0.0f;
    private float rotateY = 0.0f;
    private float rotateZ = 0.0f;

    private float m_fovy   = 60.0f;
    private float m_aspect = 1.0f;
    private float m_zNear  = 1.0f;
    private float m_zFar   = 4.0f;

    public RegionFrame (RegionReaderListener reader, String filename, RegionLoader loader)
    {
	super ();

	m_reader = reader;
	m_loader = loader;

	// update menu bar    
	menu = new JMenuBar ();

	JMenu menu_file = new JMenu ("File");

	JMenuItem menu_file_open = new JMenuItem ("Open...");
	menu_file_open.setAction (new RegionAction (this, ActionType.OPEN));
	menu_file.add (menu_file_open);

	JMenuItem menu_file_save = new JMenuItem ("Save...");
	menu_file_save.setAction (new RegionAction (this, ActionType.SAVE));
	menu_file.add (menu_file_save);

	JMenuItem menu_file_iges = new JMenuItem ("Export IGES...");
	menu_file_iges.setAction (new RegionAction (this, ActionType.IGES));
	menu_file.add (menu_file_iges);

	menu.add (menu_file);

	setJMenuBar (menu);

	m_canvas = new RegionCanvas (m_loader);
	// m_canvas.set_transparent (true);

	// initialize the JFrame
	getContentPane().add (m_canvas.canvas (), java.awt.BorderLayout.CENTER);

	setSize (512, 512);
	setTitle (filename);
	setDefaultCloseOperation (JFrame.DISPOSE_ON_CLOSE);
	setVisible (true);

	m_canvas.start_animation ();
    }

    /* FilenameFilter
     */

    public boolean accept (File dir, String name)
    {
	if (m_action == ActionType.OPEN)
	    {
		return name.endsWith (".xml");
	    }
	if (m_action == ActionType.SAVE)
	    {
		return name.endsWith (".xml");
	    }
	if (m_action == ActionType.IGES)
	    {
		return (name.endsWith (".iges") || name.endsWith (".igs"));
	    }
	return false;
    }

    /* RegionFrameListener
     */

    public void open ()
    {
	m_action = ActionType.OPEN;

	FileDialog FD = new FileDialog (this, "Open...", FileDialog.LOAD);

	FD.setFilenameFilter (this);
	FD.show ();

	String file_dir = FD.getDirectory ();
	String filename = FD.getFile ();

	if (filename != null)
	    {
		// prepend directory?
		m_reader.open (file_dir + File.separator + filename);
	    }
    }

    public void save ()
    {
	m_action = ActionType.SAVE;

	FileDialog FD = new FileDialog (this, "Save...", FileDialog.SAVE);

	FD.setFilenameFilter (this);
	FD.show ();

	String file_dir = FD.getDirectory ();
	String filename = FD.getFile ();

	if (filename != null)
	    {
		m_loader.save (file_dir + File.separator + filename);
	    }
    }

    public void export_IGES ()
    {
	m_action = ActionType.IGES;

	FileDialog FD = new FileDialog (this, "Export IGES...", FileDialog.SAVE);

	FD.setFilenameFilter (this);
	FD.show ();

	String file_dir = FD.getDirectory ();
	String filename = FD.getFile ();

	if (filename != null)
	    {
		export_IGES (file_dir + File.separator + filename);
	    }
    }

    public void export_IGES (String filename)
    {
	IGES iges = new IGES ();
	
	iges.add_points (m_loader);
	iges.add_lines (m_loader);

	m_loader.set_iges_vertex_list_de_seqno (iges.add_vertex_list (m_loader));
	m_loader.set_iges_edge_list_de_seqno (iges.add_edge_list (m_loader));

	iges.add_faces (m_loader);
	iges.add_manifold_solids (m_loader);

	try {
	    iges.Write (filename);
	} catch (Exception e) {
	    // ...
	}
    }
}
