/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

import java.io.*;
import java.util.Scanner;
import java.util.*;

public class RegionHandler extends DefaultHandler {
    private RegionLoader RR;
    boolean recorddata;
    int vert;
    String data;
    
    public RegionHandler (RegionLoader rr)
    {
	super();
	RR = rr;
	recorddata = false;
	data = new String();
    }

    public void startElement(String namespaceURI, String localName,
			     String qualifiedName, Attributes atts) throws SAXException
    {
	if (qualifiedName == "Points")
	    {
		String count = atts.getValue ("count");
		int i = Integer.valueOf(count);
		RR.points(i);
	    }
	else if (qualifiedName == "point")
	    {
		String vid = atts.getValue("id");
		String x = atts.getValue("x");
		double x1 = Double.parseDouble(x);
		String y = atts.getValue("y");
		double y1 = Double.parseDouble(y);
		String z = atts.getValue("z");
		double z1 = Double.parseDouble(z);
		RR.add_point(vid,x1,y1,z1);
	    }
	else if (qualifiedName == "Vertices")
	    {
		String count = atts.getValue ("count");
		int i = Integer.valueOf(count);
		RR.vertices(i);
	    }
	else if (qualifiedName == "Vertex")
	    {
		String vid = atts.getValue("id");
		int v = Integer.parseInt(vid);
		String x = atts.getValue("x");
		double x1 = Double.parseDouble(x);
		String y = atts.getValue("y");
		double y1 = Double.parseDouble(y);
		String z = atts.getValue("z");
		double z1 = Double.parseDouble(z);
		String bool = atts.getValue("bInternal");
		boolean b = Boolean.parseBoolean(bool);
		RR.add_vertex(v,x1,y1,z1,b);		
	    }
	else if ( qualifiedName == "Regions")
	    {
		String rcount = atts.getValue("count");
	        int r = Integer.parseInt(rcount);
		RR.regions(r);
	    }
	else if ( qualifiedName == "Region")
	    {
	      	String r0 = atts.getValue("point");
		
		String r1 = atts.getValue("vertices");
		int v = Integer.parseInt(r1);
		String r2 = atts.getValue("facets");
		int f = Integer.parseInt(r2);
		String r3 = atts.getValue("internal");
		boolean b  = Boolean.parseBoolean(r3);
		RR.add_region(r0,v,f,b);
	    }
	else if( qualifiedName == "Facet")
	    {
		recorddata = true;
		data = "";
		String facet = atts.getValue("vertices");
		vert = Integer.parseInt(facet);
		
	    }
	

    }
    
    public void endElement(String namespaceURI, String localName,
			   String qualifiedName) throws SAXException
    {
	if (qualifiedName == "Facet")
	    {
		recorddata = false;

		Vector<Integer> f = new Vector<Integer>(vert);

		Scanner scanner = new Scanner(data).useDelimiter("\t");
		while (scanner.hasNextLong()) {
		    f.addElement(new Integer(scanner.nextInt()));
		}
		scanner.close();
		RR.add_facet(f);
	    }
    }
    
    public void characters(char[ ] ch, int start, int length) throws SAXException
    {
        if(recorddata)
	    {
		data += new String(ch,start,length);
	    }
	
    }
}
