/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;

import java.util.*;
import java.lang.reflect.Array;

public class RegionReader extends ApplicationAdapter implements RegionReaderListener
{
    public static void main (String[] args)
    {
	int length = Array.getLength (args);

	if (length == 0) // running as a Mac OS X application
	    {
		RegionReader RR = new RegionReader ();
		(Application.getApplication ()).addApplicationListener (RR);
		RR.open ("ani.xml");
		return;
	    }

	for (int i = 0; i < length - 1; i++)
	    {
		// System.out.print (String.format ("\targ[%d]=\"%s\"\n", i, args[i]));
	    }
	String filename = args[length-1];

	System.out.print (String.format ("Loading \"%s\"... ", filename));
	System.out.flush ();
	RegionLoader loader = RegionLoader.load (filename);
	if (loader == null)
	    {
		System.out.print ("failed! (exiting)\n");
		return;
	    }
	System.out.print ("done.\n");
	System.out.flush ();

	loader.stats ();
    }
    
    public RegionReader ()
    {
	super ();
	
	// ...
    }
    
    public void handleOpenFile (ApplicationEvent event)
    {
	open (event.getFilename ());
    }
    
    public void handleQuit (ApplicationEvent event)
    {
	// Check to see if user has unsaved changes, if not set e.setHandled(true)
	// If user has unsaved changes set e.setHandled(false) and move into code
	// that handles saving files.
	event.setHandled (true);
    }
    
    public void open (String filename)
    {
	RegionLoader loader = RegionLoader.load (filename);
	if (loader != null)
	    {
		// loader.crop_to_cube (0.5);
		// loader.crop_to_plane (0, PlaneCompare.XP, true);

		RegionFrame RF = new RegionFrame (this, filename, loader);

		// TODO: maintain vector of open frames for a Window menu
	    }
    }
}
