/* Copyright 2008 The University of Newcastle upon Tyne
 * 
 * This file is part of RegionReader.
 * 
 * RegionReader is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * RegionReader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with RegionReader.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.util.*;
// import com.sun.j3d.utils.universe.*;
// import com.sun.j3d.utils.geometry.*;
// import javax.media.j3d.*;
// import javax.vecmath.*;

public class Vertex{
    
    private int iges_index;
    private int vid;
    private double m_x;
    private double m_y;
    private double m_z;
    private boolean bInternal;

    private int point_de_seqno;

    public Vertex(int v,double x1,double y1,double z1, boolean bInternal1)
    {
	iges_index = -1;
	vid=v;
	m_x = x1;
	m_y = y1;
	m_z = z1;
	bInternal=bInternal1;
    }
    public Vertex (int v)
    {
	iges_index = -1;
	vid = v;
	m_x = 0;
	m_y = 0;
	m_z = 0;
	bInternal = true;
    }
    public Vertex (double x, double y, double z) // improper vertex - use with caution
    {
	iges_index = -1;
	vid = -1;
	m_x = x;
	m_y = y;
	m_z = z;
	bInternal = true;
    }
    
    public int vid()
    {
	return vid;
    }

    public float xf ()
    {
	return (float) m_x;
    }
    public float yf ()
    {
	return (float) m_y;
    }
    public float zf ()
    {
	return (float) m_z;
    }

    public double xd ()
    {
	return m_x;
    }
    public double yd ()
    {
	return m_y;
    }
    public double zd ()
    {
	return m_z;
    }
    public boolean bInternal()
    {
	return bInternal;
    }
    public void set_coordinates (double x, double y, double z)
    {
	m_x = x;
	m_y = y;
	m_z = z;
    }

    public void set_iges_index(int i)
    {
	iges_index = i;
    }
    public int get_iges_index()
    {
	return iges_index;
    }
    public void set_iges_point_de_seqno(int i)
    {
	point_de_seqno = i;
    }
    public int get_iges_point_de_seqno()
    {
        return point_de_seqno;
    }
}

