	program TWOLOCARP

*
*	Two locus MLS program for analysing affected relative pair linkage data
*	USES MAXFUN  NOT NAG SUBROUTINES 
*	Implemented using general twolocus model (see  Cordell et al.
*	1999 (in preparation) for details
*
*	Based on program TWOLOC (see Farrall
*       	Genetic Epidemiology March 1996) 
*
*

      	IMPLICIT DOUBLE PRECISION(A-H,O-Z)

	PARAMETER (NP=45,NPV=45)

c
	double precision popprev, wt(2000,3,3), alpha(2000,3,3) 
	integer option, nfam
	common/mainblock/popprev, wt, alpha, option, nfam

	double precision zz(2000, 3,3),
     1  vadd(2), vdom(2), vaddadd, vdomdom, vadddom, vdomadd,
     2  lsib, lrelf, l01, l02, l10, l11, l12, l20, l21, l22, 
     3  kp, ls, lo, lmz


c
      COMMON /MAXFLB/ LABEL(NP)
      COMMON /MAXFOP/ IOUT,IDET,LPRT
      COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MAXF2/ THPR(NP),CTH(NP),STP(NP),G(NPV),H(NPV,NPV),
     $               V(NPV,NPV),AV(NP,NP),STDE(NP),ULT(NPV,NPV),
     $               DIAG(NPV),PDIR(NPV),ERM,FPR,FCH,DIFMAX,GTG,PTG,
     $               TSTEP,IST(NP),NE,ND,NI,NB,NV,IMPBND,IT,NSURF2,IGFL,
     $               IVFL,IGAGE,IVAGE,IDIF
	COMMON /XAMP2/ Y(1000), EAIJ(1000,5),PREVTR(11),RND2,CONST,N,K,KPU,
     $                                    KX
      COMMON /MKUND/ KP2,KK
C
C
C Local variables
C
      INTEGER LFL, NFE, nincr, fam, id1, id2, incr, optno
      DIMENSION THETA(8)
	
	double precision fpost(2000, 300,3,3), fprior(2000,300, 3,3),
     +lrel(2000), posn, finalres(300,10)
c






*       variables for maximalization NAG subroutine E04JAF
        double precision bl(8), bu(8), w(165), x(8), f
        integer ibound, n, ifail, iw(12), liw, lw
*
c        external E04JAF

      EXTERNAL FUNCTION
      EXTERNAL MAXFUN
      EXTERNAL DEPAR1


	write(*,*) ' '
	write(*,*) ' '
	write(*,*) 'TWOLOCARP - A program to fit a variety of two-locus'
	write(*,*) 'susceptibility gene models to affected relative pair data'
	write(*,*) ' '
	write(*,*) 'Please cite Cordell H.J. et al.  (2000) Multilocus linkage tests'
	write(*,*) 'based on affected relative pairs. (Am J Hum Genet 66: )'
15	write(*,*) ' '



c18	write(*,*) ' '
c	write(*,*) '1      two-locus general model'
c	write(*,*) '2      two-locus general model (no dominance at either locus)'
c	write(*,*) '3      two-locus general model (no dominance at locus 1)'
c	write(*,*) '4      two-locus general model (no dominance at locus 2)'
c	write(*,*) '5      two-locus additive model'
c	write(*,*) '6      two-locus additive model (no dominance at either locus)'
c	write(*,*) '7      two-locus additive model (no dominance at locus 1)'
c	write(*,*) '8      two-locus additive model (no dominance at locus 2)'
c	write(*,*) '9      single-locus model (locus 1)'
c	write(*,*) '10     single-locus model (locus 1 with no dominance)'
c	write(*,*) '11     single-locus model (locus 2)'
c	write(*,*) '12     single-locus model (locus 2 with no dominance)'
c	write(*,*) '13     multiplicative model'
c	write(*,*) '14     multiplicative model (no dominance at either locus)'
c	write(*,*) '15     multiplicative model (no dominance at locus 1)'
c	write(*,*) '16     multiplicative model (no dominance at locus 2)'
c	write(*,*) '20     calculate a single likelihood'
c	write(*,*) '  '
c	write(*,*) 'Enter which model you wish to fit :'
c	read(*,*) option
c	if (option .lt. 1 .or. option .gt. 16) then
c	write(*,*) option, ' is not a valid choice, please try again: '
c	go to 18
c	end if



	write(*,*) ' '
	open(8,file = 'twoprior.dat', status = 'old')
	open(9,file = 'twoposterior.dat' , status = 'old')
	open(10,file = 'twomlsfull.out', status = 'unknown')
	read(9,*) popprev
	read(9,*) nfam
	read(9,*) nincr

	write(10,*) ' '
	write(10,*) ' '
	write(10,*) 'TWOLOCARP - A program to fit a variety of two-locus'
	write(10,*) 'susceptibility gene models to affected relative pair data'
	write(10,*) ' '
	write(10,*) 'Please cite Cordell H.J. et al.  (2000) Multilocus linkage tests'
	write(10,*) 'based on affected relative pairs. (Am J Hum Genet 66: )'
	write(10,*) ' '




c	ACTUALLY nfam IS NUMBER OF AFFECTED PAIRS - MAX 2000
c	nincr is number of increments (eg 300 at 1cM intervals) - MAX 300

	do 2 i=1, nfam

*	read in the array of taus from posterior.dat

	do 7 incr=1,nincr

	read(9,*) posn, fam, id1, id2, fpost(i, incr, 1, 1), 
     + fpost(I,incr, 1, 2),
     + fpost(i, incr, 1, 3), fpost(I,incr, 2, 1), fpost(I,incr, 2, 2), 
     + fpost(I,incr, 2, 3),
     + fpost(I,incr, 3, 1), fpost(I,incr, 3, 2), fpost(I,incr, 3, 3)



* read in the array of alphas from prior.dat

	read(8,*) posn, fam, id1, id2, fprior(i, incr, 1,1), 
     + fprior(I,incr, 1, 2),
     + fprior(i, incr, 1,3), fprior(I,incr, 2, 1), fprior(I,incr, 2, 2), 
     + fprior(I,incr, 2, 3),
     + fprior(I,incr, 3,1), fprior(I,incr, 3, 2), fprior(I,incr, 3,3)


c	print*,' incr=',incr
c	print*,'fprior=', fprior(i, incr, 1,1), fprior(I,incr, 1, 2),
c     + fprior(i, incr, 1,3), fprior(I,incr, 2, 1), fprior(I,incr, 2, 2), 
c     + fprior(I,incr, 2, 3),
c     + fprior(I,incr, 3,1), fprior(I,incr, 3, 2), fprior(I,incr, 3,3)

7	continue 

2	continue

c	print*,' all fams read in OK'

	write(*,*) ' '
	write(*,*) ' '
	write(*,*) ' '
	write(*,*) ' '
	write(*,*) ' '

	write(*,*) ' '
        write(*,*) 'TWO-LOCUS LINKAGE ANALYSIS RESULTS'
        write(*,*) ' '

c	if (ifail .ne. -99) write(*,*) 'IFAIL = ', ifail

        write(10,*) ' '
        write(10,*) 'TWO-LOCUS LINKAGE ANALYSIS RESULTS  '
        write(10,*) ' '
c        if (ifail .ne. -99) write(10,*) 'IFAIL = ', ifail
	write(*,*) ' '
	write(10,*) ' '
	write(*,*) 'Total number of aff pairs in analysis = ', nfam
        write(10,*) 'Total number of aff pairs in analysis = ', nfam
        write(*,*) ' '
        write(10,*) ' '


c	DO WHOLE THING FOR OPTIONS 9,11,13,5,1
c	DO WHOLE THING ACROSS CHROMOSOME

	do 2001 optno=1,5

	if (optno.eq.1) option=9
	if (optno.eq.2) option=11
	if (optno.eq.3) option=13
	if (optno.eq.4) option=5
	if (optno.eq.5) option=1


	
        write(10,*) ' '
        write(10,*) ' '
	if (option .eq. 1) then
	write(10,*) 'option = 1 - general model'  
	write(10,*) 'all 8 variance components iterated'
	endif
	if (option .eq. 2) then
	write(10,*) 'option = 2 - general with no dominance variance' 
	write(10,*) 'components for either locus'
	endif
	if (option .eq. 3) then
	write(10,*) 'option = 3 - general with no dominance variance' 
	write(10,*) 'components for locus 1'
	endif
	if (option .eq. 4) then
	write(10,*) 'option = 4 - general with no dominance variance' 
	write(10,*) 'components for locus 2'
	endif
	if (option .eq. 5) then
	write(10,*) 'option = 5 - additive model' 
	write(10,*) 'includes dominance components)'
	endif
	if (option .eq. 6) then
	write(10,*) 'option = 6 - additive model with no dominance '
	write(10,*) 'component for either locus'
	endif
	if (option .eq. 7) then
	write(10,*) 'option = 7 - additive model with no dominance '
	write(10,*) 'component for locus 1'
	endif
	if (option .eq. 8) then
	write(10,*) 'option = 8 - additive model with no dominance '
	write (10,*) 'component for locus 2'
	endif
        if (option .eq. 9) then
	write(10,*) 'option = 9 - Locus 1 on its own with dominance '
        write(10,*) 'variance'
	endif
        if (option .eq. 10) then
	write(10,*) 'option = 10 - Locus 1 on its own with no dominance '
        write(10,*) 'variance'
	endif
        if (option .eq. 11) then
	write(10,*) 'option = 11 - Locus 2 on its own with dominance '
        write(10,*) 'variance'
	endif
        if (option .eq. 12) then
	write(12,*) 'option = 12 - Locus 2 on its own with no dominance '
        write(10,*) 'variance'
	endif
	if (option .eq. 13) then
	write(10,*) 'option = 13 - Risch multiplicative model '
        write(10,*) ' (includes dominance components)'
	endif
	if (option .eq. 14) then
	write(10,*) 'option = 14 - Risch multiplicative model with '
        write(10,*) 'no dominance component for either locus'
	endif
	if (option .eq. 15) then
	write(10,*) 'option = 15 - Risch multiplicative model with '
        write(10,*) 'no dominance component for locus 1'
	endif
	if (option .eq. 16) then
	write(10,*) 'option = 16 - Risch multiplicative model with '
        write(10,*) ' no dominance component for locus 2'
	endif


	do 2000 incr=1,nincr


	do 1010 I=1,nfam

c	   print*,'pair=',i

	do 1011 j=1,3
	do 1012 k=1,3
	wt(I,j,k)=fpost(I,incr,j,k)
	alpha(I,j,k)=fprior(I,incr,j,k)

	
c	print*,' alpha',j, k, '=',alpha(i,j,k)

1012	continue
1011	continue

1010	continue


*	bias weights with prior probability for IBD matrix

 	do 3 i=1,nfam
 	do 3 j=1,3
 	do 3 k=1,3
 	if (alpha(I,j,k) .gt. 0.0d0) then
 	wt(i,j,k) = wt(i,j,k)/alpha(I,j,k)
 	else
 	wt(i,j,k) = 0.0d0
 	end if
3	continue

*	maximum number of interated parameters = 8 for general model
*
*	option = 1	all 8 variance components iterated
*	option = 2	general with no dominance variance components for either locus
*	option = 3	general with no dominance variance components for locus 1
*	option = 4	general with no dominance variance components for locus 2
*	option = 5	additive model
*	option = 6	additive model with no dominance variance components for either locus
*	option = 7	additive model with no dominance variance components for locus 1
*	option = 8	additive model with no dominance variance components for locus 2
*	option = 9	locus 1 on it's own
*	option = 10	locus 1 on it's own with no dominance variance
*	option = 11	locus 2 on it's own
*	option = 12	locus 2 on it's own with no dominance variance
*	option = 13	multiplicative model
*	option = 14	multiplicative model with no dominance variance components for either locus
*	option = 15	multiplicative model with no dominance variance component for locus 1
*	option = 16	multiplicative model with no dominance variance component for locus 2
*	option = 20	calculate a single likelihood
*
*	initialize x
*
	do i=1,8
	x(i) = 0.001d0
	end do


	if (option .eq. 1 .or. option .eq. 20) then
	n = 8
	else
	if (option .eq. 2 .or. option .eq. 7 .or. option .eq. 8
     1  .or. option .eq. 15 .or. option .eq. 16) then
	n = 3
	else
	if (option .eq. 3 .or. option .eq. 4) then
	n = 5
	else
	if (option .eq. 5 .or. option .eq. 13) then
	n = 4
	else
	if (option .eq. 6 .or. option .eq. 9 .or. option .eq. 11
     1  .or. option .eq. 14) then
	n = 2
	else
	if (option .eq. 10 .or. option .eq. 12) then
	n = 1
	end if
	end if
	end if
	end if
	end if
	end if

	NT=n
	model=option

c	ibound = 3
c	bl(1) = 0.0d0
c	bu(1) = 1.0d0
c	liw = 12
c	lw = 165
c	ifail = 1
c	nfe = 0

	if (option .ne. 20) then
c
C Set up maxfun structures
C See manual for details
      IOUT     = 0
      IDET     = 0
      IXVC     = 0
      METHOD   =1
      

      THIN(1) = 0.001
      THL(1)  = 1.0D-16
      THU(1)  = 1.0
      ISTIN(1)= 1
      THIN(2) = 0.001
      THL(2)  = 1.0D-16
      THU(2)  = 1.0
      ISTIN(2)= 1
      THIN(3) = 0.001
      THL(3)  = 1.0D-16
      THU(3)  = 1.0
      ISTIN(3)= 1
      THIN(4) = 0.001
      THL(4)  = 1.0D-16
      THU(4)  = 1.0
      ISTIN(4)= 1
      THIN(5) =0.001
      THL(5)  =1.0D-16
      THU(5)  =1.0
      ISTIN(5)= 1
      THIN(6) = 0.001
      THL(6)  =1.0D-16
      THU(6)  = 1.0
      ISTIN(6)= 1
      THIN(7) = 0.001
      THL(7)  =1.0D-16
      THU(7)  = 1.0
      ISTIN(7)= 1
      THIN(8) = 0.001
      THL(8)  =1.0D-16
      THU(8)  = 1.0
      ISTIN(8)= 1

      MAXIT= 1000

C Call Maxfun with the function to be evaluated, the function to
C check the bounds of the parameters, the array of initial values,
C an integer for the number of times the function is evaluated,
C and an error return code.
c
c
c	print*,'OK up to call maxfun'
c
      CALL MAXFUN(FUNCTION, DEPAR1, THETA, F, NFE, LFL)
c
c
c
	else
c	call funct1(n,x,f)
	CALL FUNCTION(x, FTR, NFE, LEX)
	endif



*	the population prevalence (kp) has to set to something

        kp = popprev
 
	if (option .eq. 1 .or. option .eq. 20) then
*	general model
        vadd(1) = THETA(1)
        vadd(2) = THETA(2)
        vdom(1) = THETA(3)
        vdom(2) = THETA(4)
        vaddadd = THETA(5)
        vadddom = THETA(6)
        vdomadd = THETA(7)
        vdomdom = THETA(8)
	end if
*
	if (option .eq. 2) then
*	general but no dominance components
        vadd(1) = THETA(1)
        vadd(2) = THETA(2)
	vdom(1) = 0.0d0
	vdom(2) = 0.0d0
        vaddadd = THETA(3)
	vadddom = 0.0d0
	vdomadd = 0.0d0
	vdomdom = 0.0d0
	end if

	if (option .eq. 3) then
*	general, no dominance for locus 1
	vadd(1) = THETA(1)
        vadd(2) = THETA(2)
	vdom(1) = 0.0d0
	vdom(2) = THETA(3)
	vaddadd = THETA(4)
	vadddom = THETA(5)
	vdomadd = 0.0d0
	vdomdom = 0.0d0
	end if

        if (option .eq. 4) then
*       general, no dominance for locus 2
        vadd(1) = THETA(1)
        vadd(2) = THETA(2)
        vdom(1) = THETA(3)
        vdom(2) = 0.0d0
        vaddadd = THETA(4)
        vadddom = 0.0d0
        vdomadd = THETA(5)
        vdomdom = 0.0d0
        end if


	if (option .eq. 5) then
*	additive model
	vadd(1) = THETA(1)
	vadd(2) = THETA(2)
	vdom(1) = THETA(3)
	vdom(2) = THETA(4)
	vaddadd = 0.0d0
	vadddom = 0.0d0
	vdomadd = 0.0d0
	vdomdom = 0.0d0
	end if
 
	if (option .eq. 6) then
*	additive but no dominance components
	vadd(1) = THETA(1)
	vadd(2) = THETA(2)
	vdom(1) = 0.0d0
	vdom(2) = 0.0d0
	vaddadd = 0.0d0
	vadddom = 0.0d0
	vdomadd = 0.0d0
	vdomdom = 0.0d0
	end if
*
	if (option .eq. 7) then
*	additive, no dominance for locus 1
        vadd(1) = THETA(1)
        vadd(2) = THETA(2)
        vdom(1) = 0.0d0
        vdom(2) = THETA(3)
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
	end if
*
        if (option .eq. 8) then
*       additive, no dominance for locus 2
        vadd(1) = THETA(1)
        vadd(2) = THETA(2)
        vdom(1) = THETA(3)
        vdom(2) = 0.0d0
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*
        if (option .eq. 9) then
*       locus 1 on it's own
        vadd(1) = THETA(1)
        vadd(2) = 0.0d0
        vdom(1) = THETA(2)
        vdom(2) = 0.0d0
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if

*
        if (option .eq. 10) then
*       locus 1 on it's own, no dominance variance
        vadd(1) = THETA(1)
        vadd(2) = 0.0d0
        vdom(1) = 0.0d0
        vdom(2) = 0.0d0
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if


*
        if (option .eq. 11) then
*       locus 2 on it's own
        vadd(1) = 0.0d0
        vadd(2) = THETA(1)
        vdom(1) = 0.0d0
        vdom(2) = THETA(2)
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if

*
        if (option .eq. 12) then
*       locus 2 on it's own, no dominance variance
        vadd(1) = 0.0d0
        vadd(2) = THETA(1)
        vdom(1) = 0.0d0
        vdom(2) = 0.0d0
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if

        if (option .eq. 13) then
*	multiplicative
        vadd(1) = THETA(1)
        vadd(2) = THETA(2)
        vdom(1) = THETA(3)
        vdom(2) = THETA(4)
	vaddadd = vadd(1)*vadd(2)/(kp**2)
	vadddom = vadd(1)*vdom(2)/(kp**2)
	vdomadd = vdom(1)*vadd(2)/(kp**2)
	vdomdom = vdom(1)*vdom(2)/(kp**2)
        end if

	if (option .eq. 14) then
*	multiplicative with no dominance variance
	vadd(1) = THETA(1)
	vadd(2) = THETA(2)
	vdom(1) = 0.0d0
	vdom(2) = 0.0d0
        vaddadd = vadd(1)*vadd(2)/(kp**2)
        vadddom = vadd(1)*vdom(2)/(kp**2)
        vdomadd = vdom(1)*vadd(2)/(kp**2)
        vdomdom = vdom(1)*vdom(2)/(kp**2)
 	end if

        if (option .eq. 15) then
*       multiplicative with no dominance variance for locus 1
        vadd(1) = THETA(1)
        vadd(2) = THETA(2)
        vdom(1) = 0.0d0
        vdom(2) = THETA(3)
        vaddadd = vadd(1)*vadd(2)/(kp**2)
        vadddom = vadd(1)*vdom(2)/(kp**2)
        vdomadd = vdom(1)*vadd(2)/(kp**2)
        vdomdom = vdom(1)*vdom(2)/(kp**2)
        end if

        if (option .eq. 16) then
*       multiplicative with no dominance variance for locus 2
        vadd(1) = THETA(1)
        vadd(2) = THETA(2)
        vdom(1) = THETA(3)
        vdom(2) = 0.0d0
        vaddadd = vadd(1)*vadd(2)/(kp**2)
        vadddom = vadd(1)*vdom(2)/(kp**2)
        vdomadd = vdom(1)*vadd(2)/(kp**2)
        vdomdom = vdom(1)*vdom(2)/(kp**2)
        end if

c	THIS BELOW WOULD BE JUST FOR 1st Affected pair
c
	if (option .le. 16.0d0 .or. option .eq. 20) then
	lrel(1) = lrelf(1,alpha, kp, vadd, vdom, vaddadd, 
     $vadddom, vdomadd, vdomdom)
	zz(1,1,1) = alpha(1,1,1) * 1.0d0 / lrel(1)
        	zz(1,1,2) = alpha(1,1,2) * l01(kp,vadd(2)) / lrel(1)
	zz(1,1,3) = alpha(1,1,3) * l02(kp,vadd(2),vdom(2)) / lrel(1)
	zz(1,2,1) = alpha(1,2,1) * l10(kp,vadd(1)) / lrel(1)
	zz(1,2,2) = alpha(1,2,2) * l11(kp,vadd,vaddadd) / lrel(1)
	zz(1,2,3) = alpha(1,2,3) * l12(kp,vadd,vdom(2),vaddadd,
     $vadddom) / lrel(1)
	zz(1,3,1) = alpha(1,3,1) * l20(kp,vadd(1),vdom(1)) / lrel(1)
	zz(1,3,2) = alpha(1,3,2) * l21(kp,vadd,vdom(1),vaddadd,
     $vdomadd) / lrel(1)
	zz(1,3,3) = alpha(1,3,3) * l22(kp,vadd,vdom,vaddadd,vadddom,
     $vdomadd,vdomdom) / lrel(1)
	else
c      	multiplicative models
	end if

c	do 32 I=1,3
c	do 32 j=1,3
c	write(10,*) 'I,j, z=', I,j, zz(1,I,j)
c32	continue

        write(*,35) ' Number of function evaluations = ',nfe
        write(*,*) ' '
c        write(10,35) ' Number of function evaluations = ',nfe
c        write(10,*) ' '
35     format(a34,2x,i6)

        write(10,*) ' ' 
        write(10,*) 'WARNING: THE FOLLOWING VARIANCE COMPONENTS '
	write(10,*) 'MUST NOT BE INTERPRETED'
        write(10,*) 'AS MAXIMUM LIKELIHOOD ESTIMATES'
        write(10,*) ' '

        write(10,*) 'Vadd(1)=',vadd(1)
        write(10,*) 'Vadd(2)=',vadd(2)
        write(10,*) 'Vdom(1)=',vdom(1)
        write(10,*) 'Vdom(2)=',vdom(2)
        write(10,*) 'Vaddadd=',vaddadd
        write(10,*) 'Vadddom=', vadddom
        write(10,*) 'Vdomadd=', vdomadd
        write(10,*) 'Vdomdom=',vdomdom

        write(10,*) ' '
        write(10,*) 'Vadd(1)/k^2=',vadd(1)/(kp**2)
        write(10,*) 'Vadd(2)/k^2=',vadd(2)/(kp**2)
        write(10,*) 'Vdom(1)/k^2=',vdom(1)/(kp**2)
        write(10,*) 'Vdom(2)/k^2=',vdom(2)/(kp**2)
        write(10,*) 'Vaddadd/k^2=',vaddadd/(kp**2)
        write(10,*) 'Vadddom/k^2=', vadddom/(kp**2)
        write(10,*) 'Vdomadd/k^2=', vdomadd/(kp**2)
        write(10,*) 'Vdomdom/k^2=',vdomdom/(kp**2)



        if (option.eq.13) then
        write(10,*)
        write(10,*) '1+(1/k^2)[0.5Vadd(1)+0.25Vdom(1)]=', 
     +1.0+(1/(kp**2))*( 0.5*vadd(1)+0.25*vdom(1))
        write(10,*)
        write(10,*) '1+(1/k^2)[0.5Vadd(2)+0.25Vdom(2)]=', 
     +1.0+(1/(kp**2))*( 0.5*vadd(2)+0.25*vdom(2))
        write(10,*)
        end if

        if ((option.eq.1).or.(option.eq.5)) then
        write(10,*)
        write(10,*) '(1/k^2)[0.5Vadd(1)+0.25Vdom(1)]=', 
     +(1/(kp**2))*( 0.5*vadd(1)+0.25*vdom(1))
        write(10,*)
        write(10,*) '(1/k^2)[0.5Vadd(2)+0.25Vdom(2)]=', 
     +(1/(kp**2))*( 0.5*vadd(2)+0.25*vdom(2))
        write(10,*)
        end if

	write(10,*) ' '
	write(10,*) ' '

        write(10,*)  '2:1:1:0 joint IBD  for 1st affected pair'
        write(10,*) ' '
        write(10,*) ' '
 	write(10,*)  '                   0            1  	      2'
	write(10,40) zz(1,1,1),zz(1,1,2),zz(1,1,3)
	write(10,41) zz(1,2,1),zz(1,2,2),zz(1,2,3)
	write(10,42) zz(1,3,1),zz(1,3,2),zz(1,3,3)
	write(10,*) ' '
        write(10,*) ' '
        write(10,*) ' '
        write(10,*) ' Note: locus 1 in rows, locus 2 in columns'
        write(10,*) ' '

40	format('0        ',3f14.6)
41	format('1        ',3f14.6)
42	format('2        ',3f14.6)

	write(*,*) 'MLS = ', f
        write(10,46) 'Position= ',incr, ' MLS =  ', f
46	format(a15,2x,i5,a6,2x,f8.3)


	finalres(incr,10)=incr
	finalres(incr,optno)=f

		

1000	continue


2000	continue
2001	continue


        write(10,*) ' '
        write(10,*) ' ' 

      write(10,*) 'FINAL MLS RESULTS FOR LOCUS 2'
      write(10,*) ' ' 
      write(10,*) ' ' 

	do 2010 incr=1,nincr
	
	write(10, 47) finalres(incr,10), finalres(incr,2), 
     +finalres(incr,3)-finalres(incr,1),
     +finalres(incr,4)-finalres(incr,1),
     +finalres(incr,5)-finalres(incr,1)

2010	continue

47	format(5f12.4)

	close(10)


	stop
	end


	
c	subroutine funct1(n,xc,fc)

	SUBROUTINE FUNCTION(TR, FTR, NFE, LEX)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C The function to be evaluated:
C  Parameters:  TR  - trial paramters
C               FTR - function value with parameters tr
C               NFE - number of times the function has been evaluated
C               LEX - error code
c

c	COMMON VARIABLES


	double precision popprev, wt(2000,3,3), alpha(2000,3,3)
	integer option, nfam
	common/mainblock/popprev, wt, alpha, option, nfam

c	LOCAL VARIABLES

	double precision zz(2000,3,3), xc(8), like, top, bottom, fc,
     1  vadd(2), vdom(2), vaddadd, vdomdom, vadddom, vdomadd,
     2  lsib, lsibf, l01, l02, l10, l11, l12, l20, l21, l22, kp, 
     +ls, lo, lmz,
     +lrel(2000), lrelf


	integer n, nf, nfe

	INTEGER I, j


	DIMENSION TR(*)
      	EXTERNAL DEPAR1

C 	Check the parameters are valid
      	CALL DEPAR1(TR, LEX)
      	IF (LEX .GT. 0) RETURN

C Calculate function

	FTR=0

	if (option .eq. 1 .or. option .eq. 20) then
	n = 8
	else
	if (option .eq. 2 .or. option .eq. 7 .or. option .eq. 8
     1  .or. option .eq. 15 .or. option .eq. 16) then
	n = 3
	else
	if (option .eq. 3 .or. option .eq. 4) then
	n = 5
	else
	if (option .eq. 5 .or. option .eq. 13) then
	n = 4
	else
	if (option .eq. 6 .or. option .eq. 9 .or. option .eq. 11
     1  .or. option .eq. 14) then
	n = 2
	else
	if (option .eq. 10 .or. option .eq. 12) then
	n = 1
	end if
	end if
	end if
	end if
	end if
	end if

	do 10 I=1,n
	xc(I)=TR(I)
10	continue

*	set population prevalence to something vaguely plausible

	kp = popprev

	if (option .eq. 1 .or. option .eq. 20) then
*	general model
	vadd(1) = xc(1)
	vadd(2) = xc(2)
	vdom(1) = xc(3)
	vdom(2) = xc(4)
	vaddadd = xc(5)
	vadddom = xc(6)
	vdomadd = xc(7)
	vdomdom = xc(8)
	end if
*
	if (option .eq. 2) then
*	general but no dominance components
	vadd(1) = xc(1)
	vadd(2) = xc(2)
	vdom(1) = 0.0d0
	vdom(2) = 0.0d0
	vaddadd = xc(3)
	vadddom  = 0.0d0
	vdomadd = 0.0d0
	vdomdom = 0.0d0
	end if
*
        if (option .eq. 3) then
*       general, no dominance for locus 1
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = 0.0d0
        vdom(2) = xc(3)
        vaddadd = xc(4)
        vadddom = xc(5)
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*
        if (option .eq. 4) then
*       general, no dominance for locus 1
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = xc(3)
        vdom(2) = 0.0d0
        vaddadd = xc(4)
        vadddom = 0.0d0
        vdomadd = xc(5)
        vdomdom = 0.0d0
        end if
*
	if (option .eq. 5) then
*	additive model
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = xc(3)
        vdom(2) = xc(4)
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*
        if (option .eq. 6) then
*       additive but no dominance components
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = 0.0d0
        vdom(2) = 0.0d0
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*
        if (option .eq. 7) then
*       additive, no dominance for locus 1
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = 0.0d0
        vdom(2) = xc(3)
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*	
        if (option .eq. 8) then
*       additive, no dominance for locus 2
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = xc(3)
        vdom(2) = 0.0d0
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*
        if (option .eq. 9) then
*       locus 1 on it's own
        vadd(1) = xc(1)
        vadd(2) = 0.0d0
        vdom(1) = xc(2)
        vdom(2) = 0.0d0
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*

        if (option .eq. 10) then
*       locus 1 on it's own, no dominance variance
        vadd(1) = xc(1)
        vadd(2) = 0.0d0
        vdom(1) = 0.0d0
        vdom(2) = 0.0d0
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*


        if (option .eq. 11) then
*       locus 2 on it's own
        vadd(1) = 0.0d0
        vadd(2) = xc(1)
        vdom(1) = 0.0d0
        vdom(2) = xc(2)
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*

        if (option .eq. 12) then
*       locus 2 on it's own, no dominance variance
        vadd(1) = 0.0d0
        vadd(2) = xc(1)
        vdom(1) = 0.0d0
        vdom(2) = 0.0d0
        vaddadd = 0.0d0
        vadddom = 0.0d0
        vdomadd = 0.0d0
        vdomdom = 0.0d0
        end if
*
        if (option .eq. 13) then
*       multiplicative
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = xc(3)
        vdom(2) = xc(4)
        vaddadd = vadd(1)*vadd(2)/(kp**2)
        vadddom = vadd(1)*vdom(2)/(kp**2)
        vdomadd = vdom(1)*vadd(2)/(kp**2)
        vdomdom = vdom(1)*vdom(2)/(kp**2)      
        end if
 
        if (option .eq. 14) then
*       multiplicative with no dominance variance
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = 0.0d0
        vdom(2) = 0.0d0
        vaddadd = vadd(1)*vadd(2)/(kp**2)
        vadddom = vadd(1)*vdom(2)/(kp**2)
        vdomadd = vdom(1)*vadd(2)/(kp**2)
        vdomdom = vdom(1)*vdom(2)/(kp**2)    
        end if
 
        if (option .eq. 15) then
*       multiplicative with no dominance variance for locus 1
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = 0.0d0
        vdom(2) = xc(3)
        vaddadd = vadd(1)*vadd(2)/(kp**2)
        vadddom = vadd(1)*vdom(2)/(kp**2)
        vdomadd = vdom(1)*vadd(2)/(kp**2)
        vdomdom = vdom(1)*vdom(2)/(kp**2)    
        end if
 
        if (option .eq. 16) then
*       multiplicative with no dominance variance for locus 2
        vadd(1) = xc(1)
        vadd(2) = xc(2)
        vdom(1) = xc(3)
        vdom(2) = 0.0d0
        vaddadd = vadd(1)*vadd(2)/(kp**2)
        vadddom = vadd(1)*vdom(2)/(kp**2)
        vdomadd = vdom(1)*vadd(2)/(kp**2)
        vdomdom = vdom(1)*vdom(2)/(kp**2)    
        end if
*	
*	
*	compute joint IBD matrix from variance components model


	nfe = nfe + 1
c	write(*,135) ' Number of function evaluations = ',nfe
c	write(*,*) ' '
135	format(a34,2x,i6)

136     format(8g10.2)
        
c	write(*,*)
c     1  '  Vadd(1)   Vadd(2)   Vdom(1)   Vdom(2)   Vaddadd   Vadddom   Vdomadd   Vdomdom'

c	write(*,136)
c     1  vadd(1), vadd(2), vdom(1), vdom(2), vaddadd, vadddom, vdomadd, vdomdom


140     format(a11,4f14.4)
	like=0.0d0
	do 110 nf=1,nfam

c	print*,'pair=',nf
c	print*,'alpha=', ((alpha(nf,i,j), i=1,3), j=1,3)

	if (option .le. 16.0d0 .or. option .eq. 20) then
	lrel(nf) = lrelf(nf,alpha, kp, vadd, vdom, vaddadd, vadddom, 
     +vdomadd, vdomdom)
c	print*,'lrel=',lrel(nf)
        	zz(nf,1,1) = alpha(nf,1,1) * 1.0d0 / lrel(nf)
        	zz(nf,1,2) = alpha(nf,1,2) * l01(kp,vadd(2)) / lrel(nf)
	zz(nf,1,3) = alpha(nf,1,3) * l02(kp,vadd(2),vdom(2)) / lrel(nf)
	zz(nf,2,1) = alpha(nf,2,1) * l10(kp,vadd(1)) / lrel(nf)
	zz(nf,2,2) = alpha(nf,2,2) * l11(kp,vadd,vaddadd) / lrel(nf)
	zz(nf,2,3) = alpha(nf,2,3) * l12(kp,vadd,vdom(2),vaddadd,
     +vadddom) / lrel(nf)
	zz(nf,3,1) = alpha(nf,3,1) * l20(kp,vadd(1),vdom(1)) / lrel(nf)
	zz(nf,3,2) = alpha(nf,3,2) * l21(kp,vadd,vdom(1),vaddadd,
     +vdomadd) / lrel(nf)
	zz(nf,3,3) = alpha(nf,3,3) * l22(kp,vadd,vdom,vaddadd,vadddom,
     +vdomadd,vdomdom) / lrel(nf)
	else
*       multiplicative models
	end if



	top = 0.0d0
	bottom = 0.0d0
	do 100 i=1,3
	do 100 j=1,3
	top = top + zz(nf,i,j)*wt(nf,i,j)
100	continue
	if (top .gt. 0.0d0) like = like + log10(top)
c	print*,' likeli=',like
110	continue
c	write(*,115) 'log10(likelihood) = ',like
c	write(*,*) 'lrel=',lrel(1)
c	print*,'like=',like
c	write(*,*) ' '
c	write(*,*) ' '
c	write(*,*) ' '
115	format(a20,2x,f12.6)
	fc = -like
	FTR= -fc
	return
	end


	double precision function lrelf(nf, alpha, kp, vadd, vdom, 
     +vaddadd, vadddom, vdomadd, vdomdom)

*	function to calculate the recurrence risk ratio for the relative of an affected
*	individual under a two-locus susceptibility gene model. kp denotes
*	the population prevalence, vadd(1) and vadd(2) denote the additive variance for the
*	first and second susceptibility genes, vdom(1) and vdom(2) denote the dominance variance
*	components for the two genes, and vaddadd, vadddom, vdomadd, vdomdom denote the
*	various epistatic variance components (additive X additive, additive X dominance,
*	dominance X additive, dominance X dominance). nf is the pair and alpha the prior
c	probs for the pair of sharing 2,1,0.

C	RECTHETA IS IRRELEVENT SINCE WE HAVE CALCULATED
c	JOINT PROBS AS INPUT



	integer nf
	double precision alpha(2000,3,3), kp, vadd(2),vdom(2), vaddadd, 
     +vdomdom, vadddom, vdomadd

	double precision tmp(8)

	tmp(1) =  0.5*(alpha(nf,3,3)+alpha(nf,3,2)+alpha(nf,3,1))+
     +0.25*(alpha(nf,2,3)+alpha(nf,2,2)+alpha(nf,2,1))
	tmp(2)=tmp(1)
	tmp(3)= (alpha(nf,3,3)+alpha(nf,3,2)+alpha(nf,3,1))
	tmp(4)=tmp(3)
	tmp(5)=0.25*alpha(nf,3,3)+0.125*alpha(nf,2,3)+
     +0.125*alpha(nf,3,2)+0.0625*alpha(nf,2,2)
	tmp(6)=0.5*alpha(nf,3,3)+0.25*alpha(nf,2,3)
	tmp(7)=tmp(6)
	tmp(8)=alpha(nf,3,3)

c	print*,'tmp=',tmp(1), tmp(2), tmp(3), tmp(4), tmp(5),tmp(6), tmp(7),tmp(8)

	lrelf = 1 + 1/(kp*kp)*(2*tmp(1)*vadd(1)+2*tmp(2)*vadd(2)+
     +tmp(3)*vdom(1)+tmp(4)*vdom(2)+
     +4*tmp(5)*vaddadd+2*tmp(6)*vadddom+2*tmp(7)*vdomadd+tmp(8)*vdomdom)

	return
	end



	double precision function l01(kp,vadd)

*	function to calculate the recurrence risk ratio for two individuals
*	that share exactly 0 and 1 genes IBD at two susceptibility genes

	double precision kp, vadd

	l01 = 1.0d0 + 1.0d0/(kp*kp)*(vadd/2.0d0)
	return
	end

        double precision function l10(kp,vadd)
 
*       function to calculate the recurrence risk ratio for two individuals
*       that share exactly 1 and 0 genes IBD at two susceptibility genes
 
        double precision kp, vadd
 
        l10 = 1.0d0 + 1.0d0/(kp*kp)*(vadd/2.0d0)
        return
        end

        double precision function l02(kp,vadd,vdom)
 
*       function to calculate the recurrence risk ratio for two individuals
*       that share exactly 0 and 2 genes IBD at two susceptibility genes
 
	double precision kp, vadd, vdom

	l02 = 1.0d0 + 1.0d0/(kp*kp)*(vadd+vdom)
	return
	end

        double precision function l20(kp,vadd,vdom)

*       function to calculate the recurrence risk ratio for two individuals
*       that share exactly 2 and 0 genes IBD at two susceptibility genes
 
        double precision kp, vadd, vdom
 
        l20 = 1.0d0 + 1.0d0/(kp*kp)*(vadd+vdom)
        return
        end

	double precision function l12(kp,vadd,vdom,vaddadd,vadddom)
 
*       function to calculate the recurrence risk ratio for two individuals
*       that share exactly 1 and 2 genes IBD at two susceptibility genes

	double precision kp, vadd(2), vdom, vaddadd, vadddom

	l12 = 1.0d0 +
     1  1.0d0/(kp*kp)*(vadd(1)/2.0d0 + vadd(2) + vdom + 
     + vaddadd/2.0d0 + vadddom/2.0d0)
	return
	end

	double precision function l21(kp,vadd,vdom,vaddadd,vdomadd)

 
*       function to calculate the recurrence risk ratio for two individuals
*       that share exactly 2 and 1 genes IBD at two susceptibility genes

	double precision kp, vadd(2), vdom, vaddadd, vdomadd

	l21 = 1.0d0 +
     1  1.0d0/(kp*kp)*(vadd(2)/2.0d0 + vadd(1) + vdom + 
     + vaddadd/2.0d0 + vdomadd/2.0d0)
	return
	end

	double precision function l11(kp,vadd, vaddadd)

*       function to calculate the recurrence risk ratio for two individuals
*       that share exactly 1 and 1 genes IBD at two susceptibility genes

	double precision kp, vadd(2), vaddadd

	l11 = 1.0d0 + 1.0d0/(kp*kp)*(vadd(1)/2.0d0 + vadd(2)/2.0d0 + 
     +vaddadd/4.0d0)
	return
	end

	double precision function l22(kp,vadd,vdom,vaddadd,vadddom,
     +vdomadd,vdomdom)
 
*       function to calculate the recurrence risk ratio for two individuals
*       that share exactly 2 and 2 genes IBD at two susceptibility genes

	double precision kp, vadd(2), vdom(2), vaddadd,vadddom,
     +vdomadd,vdomdom

	l22 = 1.0d0 + 1.0d0/(kp*kp)*(vadd(1) + vadd(2) + vdom(1) + 
     +vdom(2) + vaddadd +
     1  vadddom + vdomadd + vdomdom)
	return
	end

*
*	The following functions are reserved for a future implementation of the
*	multiplicative model
*	BUT MAY NOT BE NEEDED IF NEST MUL MODEL IN GENERAL
*
	double precision function ls(kp,vadd,vdom)

*	function to calculate recurrence risk ratio for siblings
*	of affected individuals

	double precision kp, vadd, vdom

	ls = 1.0d0 + 1.0d0/(kp*kp) * (vadd/2.0d0 + vdom/4.0d0)
	return
	end

        double precision function lo(kp,vadd)

*	function to calculate recurrence risk ratio for offspring
*	of affected parents
 
        double precision kp, vadd
 
        lo = 1.0d0 + 1.0d0/(kp*kp) * (vadd/2.0d0)
        return
        end

        double precision function lmz(kp,vadd,vdom)

*	function to calculate recurrence risk ratio for MZ twins
 
        double precision kp, vadd, vdom
 
        lmz = 1.0d0 + 1.0d0/(kp*kp) * (vadd + vdom)
        return
        end


	SUBROUTINE HESSIN(DF,HESS,OBS,PAR,F,ITER,KASE,MODEL,NCASE
     :,NOBS,NPAR,DIFFER)
C
C     THIS SUBROUTINE PERMITS RECOMPUTATION OF THE OBJECTIVE FUNCTION
C     F AND ITS DIFFERENTIAL DF.  IF DIFFER(2) IS TRUE, THEN PROVIDE
C     AN APPROXIMATION TO THE SECOND DIFFERENTIAL, I.E, HESSIAN OF F.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION DF(NPAR),HESS(NPAR,NPAR),OBS(NOBS)
     :,PAR(NPAR)
      LOGICAL DIFFER(2)
C
C
      END


	SUBROUTINE DEPAR1(TR,LEX)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C The function to check the parameters are in bounds and to calculate
C dependent parameters.
C
      PARAMETER (NP=45)
	COMMON /MAXF1/ THIN(NP),THL(NP),THU(NP),STPIN(NP),EPSD,YOTA,EPST,
     $               EPSC1,EPSC2,EPSC3,ISTIN(NP),NT,MAXIT,METHOD,IXVC,
     $               IHIT
      COMMON /MKUND/ KP2,KK
      DIMENSION TR(*)

c       Local variables

	integer i

c	print*,'in depar NT=',NT

C
C Calculate the dependent parameter
C 
C
C     Check that all parameters are in bounds 0-1

	do 20 i=1,NT

	   if ((TR(i).lt.0.D0).or.(TR(i).gt.1.0D0)) then

c      IF (((TR(1).LT.0.D0).OR.(TR(1).GT.1.0D0)).OR.
c     +    ((TR(2).LT.0.D0).OR.(TR(2).GT.1.0D0)).OR.
c     +    ((TR(3).LT.0.D0).OR.(TR(3).GT.1.0D0)).OR.
c     +    ((TR(4).LT.0.D0).OR.(TR(4).GT.1.0D0)).OR.
c     +    ((TR(5).LT.0.D0).OR.(TR(5).GT.1.0D0)).OR.
c     +    ((TR(6).LT.0.D0).OR.(TR(6).GT.1.0D0)).OR.
c     +    ((TR(7).LT.0.D0).OR.(TR(7).GT.1.0D0)).OR.
c     +((TR(8).LT.0.D0).OR.(TR(8).GT.1.0D0))) THEN

c	 print*,' DEPAR failed!'
c	 print*,' tr=', TR(1), TR(2), TR(3), TR(4),
c     +TR(5), TR(6), TR(7), TR(8)

         LEX = 1
         RETURN
       END IF

 20	continue

      LEX = 0

      RETURN
      END
c
c











