#threshold, an arc must be greater than the threshold to be plotted
threshold<-0.095 #0.14
plotThresholdEst<-TRUE

#load igraph library, http://igraph.org/r/
library(igraph)

#load average network graph
aveGraph<-read.table("average-network-example.dat", header=TRUE, stringsAsFactors=FALSE) #read.table("average-network-example20-i.dat", header=TRUE, stringsAsFactors=FALSE)

#plot arc strength versus cumulative number of arcs with strength <= arc strength
if(plotThresholdEst) {
png(filename="ave-graph-example-para-thresholdEst.png", width=600, height=600)
y<-c()
for(stren in aveGraph$strength) y<-append(y, sum(aveGraph$strength <= stren))
plot.stepfun(aveGraph$strength, xlab="arc strength", ylab="cumulative distribution function", verticals=FALSE, xlim=c(0,1), pch=19, main="")
abline(v=threshold, lty=2)
dev.off()
}

#create node and edge tables for igraph
#map node names to numbers
nodeList<-as.numeric(as.factor(c(aveGraph$from, aveGraph$to)))
noArcs<-length(aveGraph$from)
fromNum<-nodeList[1:noArcs]
toNum<-nodeList[(noArcs+1):(2*noArcs)]
nodes1<-as.data.frame(cbind(fromNum, aveGraph$from, aveGraph$type1))
colnames(nodes1)<-c("id", "name", "type")
nodes2<-as.data.frame(cbind(toNum, aveGraph$to, aveGraph$type2))
colnames(nodes2)<-c("id", "name", "type")
nodes<-unique(rbind(nodes1, nodes2))
edges<-as.data.frame(cbind(fromNum, toNum, aveGraph$strength, aveGraph$direction))
colnames(edges)<-c("from", "to", "strength", "direction")

#apply threshold for plotting arc/edge
edges<-edges[edges$strength > threshold,]

#create graph
graph<-graph_from_data_frame(edges, directed = TRUE, vertices = nodes)

#plot the network and output png file, edit style as required

#style for continuous nodes
shape<-rep("circle", length(nodes$type))
vcolor<-rep("#eeeeee", length(nodes$type))
vsize<-rep(25, length(nodes$type))
color<-rep("black", length(nodes$type))

#style for discrete nodes
shape[nodes$type=="d"]<-"rectangle"
vcolor[nodes$type=="d"]<-"#111111"
vsize[nodes$type=="d"]<-20
color[nodes$type=="d"]<-"white"

#style for factor nodes
shape[nodes$type=="f"]<-"rectangle"
vcolor[nodes$type=="f"]<-"#eeeeee"
vsize[nodes$type=="f"]<-20
color[nodes$type=="f"]<-"black"

#edge widths for significances
minWidth<-0.3
maxWidth<-10
edgeMax<-max(edges$strength)
edgeMin<-min(edges$strength)
widths<-((edges$strength-edgeMin)/(edgeMax-edgeMin))*(maxWidth - minWidth) + minWidth
styles<-rep(1, length(widths))

#plot to a png file
png(filename="ave-graph-example-para.png", width=800, height=800)

plot(graph, vertex.shape=shape, vertex.size=vsize, vertex.color=vcolor, vertex.label.color=color, edge.width=widths, edge.lty=styles, edge.color="black", edge.arrow.size=1.5, edge.label = signif(edges$direction,3), edge.label.cex=1.5, edge.label.color="red")

#finish png file
dev.off()

