#R file to collate average networks ran in parallel - all average networks must have been calculated with the same number of bootstraps
cmd_args<-commandArgs()

fileName<-cmd_args[4]
noFiles<-as.numeric(cmd_args[5])

totalNet<-read.table(paste(fileName,1,"-i.dat",sep=""), header=TRUE, stringsAsFactors=FALSE)

totalNet<-cbind(totalNet, rep(1, length(totalNet[,1])))
colnames(totalNet)[7]<-"count"

for(i in 2:noFiles)
{
   aveNet<-read.table(paste(fileName,i,"-i.dat",sep=""), header=TRUE, stringsAsFactors=FALSE)
   aveNet<-cbind(aveNet, rep(1, length(aveNet[,1])))
   colnames(aveNet)[7]<-"count"
   
   ##loop thro' rows of average table
   for(j in 1:length(aveNet[,1]))
   {
     ##find edge in total
     totRow<-which(aveNet$from[j]==totalNet$from & aveNet$to[j]==totalNet$to)
     if(length(totRow) == 1)
     {
         totalNet$strength[totRow]<-totalNet$strength[totRow] + aveNet$strength[j]
         totalNet$direction[totRow]<-totalNet$direction[totRow] + aveNet$direction[j]
         totalNet[totRow,7]<-totalNet[totRow,7]+1
     } else {
         totRow<-which(aveNet$from[j]==totalNet$to & aveNet$to[j]==totalNet$from)
         if(length(totRow) == 1)
         {
           totalNet$strength[totRow]<-totalNet$strength[totRow] + aveNet$strength[j]
           totalNet$direction[totRow]<-totalNet$direction[totRow] + 1 - aveNet$direction[j]
           totalNet[totRow,7]<-totalNet[totRow,7]+1
         } else {     
           totalNet<-rbind(totalNet, aveNet[j,])            
         }     
     }     
   }
}

##take average over all average networks
totalNet$strength<-totalNet$strength/noFiles
totalNet$direction<-totalNet$direction/totalNet[,7]

totalNet<-totalNet[order(-totalNet$strength),1:6]

#reorder edges if direction < 0.5
for(j in 1:length(totalNet[,1]))
{
   if(totalNet$direction[j] < 0.5)
   {
      totalNet[j,]<-c(totalNet$to[j], totalNet[j,2], totalNet$from[j], totalNet[j,4], totalNet[j,5], 1-as.numeric(totalNet[j,6]))
   }
}

write.table(totalNet, paste(fileName,".dat",sep=""), quote=FALSE, col.names=TRUE, row.names=FALSE)

#calculate suggested threshold for plotting network
cumCount = 0;
arcStrength = 0;
arcStrengths<-c()
cumArcStrengths<-c()
oas<-1
    
repeat
{
		arcStrength = rev(totalNet$strength)[oas];
		
		repeat
		{			
			oas<-oas+1
			cumCount<-cumCount+1

		 if(rev(totalNet$strength)[oas] > arcStrength || oas > length(rev(totalNet$strength))) break
    }
    
    if(length(arcStrengths) > 0 && arcStrength == arcStrengths[length(arcStrengths)])
    {
      arcStrengths[length(arcStrengths)]<-arcStrength
      cumArcStrengths[length(arcStrengths)]<-cumCount
    } else {
      arcStrengths<-append(arcStrengths, arcStrength)
      cumArcStrengths<-append(cumArcStrengths, cumCount)
     } 
     
     if(oas > length(rev(totalNet$strength))) break
}
 
bestL1score<-cumCount
propArcs<-cumArcStrengths/cumArcStrengths[length(cumArcStrengths)]

for(i in 1:length(arcStrengths)) #casTh in acumTot) 
{
    j<-1
		L1score = propArcs[i] * arcStrengths[1];
  
		prevCum = propArcs[j];
		prevStrength = arcStrengths[j];
		j<-j+1;

		while(j <= length(arcStrengths)) 
		{
			if(prevCum > propArcs[i]) L1score<-L1score + (prevCum - propArcs[i]) * (arcStrengths[j] - prevStrength)
			else L1score<-L1score + (propArcs[i] - prevCum) * (arcStrengths[j] - prevStrength)
			
			prevCum = propArcs[j];
			prevStrength = arcStrengths[j];
			j<-j+1
		}

		if(L1score < bestL1score)
		{
			bestL1score = L1score;
			bestThreshold = arcStrengths[i]
		}
}
 
write.table(bestThreshold, paste(fileName,"-threshold.dat",sep=""), quote=FALSE, col.names=FALSE, row.names=FALSE)

